# Opsuite2\SuppliersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SuppliersGet()**](SuppliersApi.md#apiV1SuppliersGet) | **GET** /api/v1/Suppliers | Returns an array of Suppliers that match the specified search criteria. |
| [**apiV1SuppliersGetSupplierByCodeGet()**](SuppliersApi.md#apiV1SuppliersGetSupplierByCodeGet) | **GET** /api/v1/Suppliers/GetSupplierByCode | Returns a single Supplier with the specified code. |
| [**apiV1SuppliersPost()**](SuppliersApi.md#apiV1SuppliersPost) | **POST** /api/v1/Suppliers | Creates a new supplier. |
| [**getSupplierById()**](SuppliersApi.md#getSupplierById) | **GET** /api/v1/Suppliers/{supplierId} | Returns a single Supplier with the specified id. |


## `apiV1SuppliersGet()`

```php
apiV1SuppliersGet($page_number, $page_size, $supplier_code, $supplier_name, $account_number, $email_address, $include_inactive): \Opsuite2\Model\Supplier[]
```

Returns an array of Suppliers that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SuppliersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$supplier_code = 'supplier_code_example'; // string
$supplier_name = 'supplier_name_example'; // string
$account_number = 'account_number_example'; // string
$email_address = 'email_address_example'; // string
$include_inactive = True; // bool

try {
    $result = $apiInstance->apiV1SuppliersGet($page_number, $page_size, $supplier_code, $supplier_name, $account_number, $email_address, $include_inactive);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuppliersApi->apiV1SuppliersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **supplier_code** | **string**|  | [optional] |
| **supplier_name** | **string**|  | [optional] |
| **account_number** | **string**|  | [optional] |
| **email_address** | **string**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\Supplier[]**](../Model/Supplier.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SuppliersGetSupplierByCodeGet()`

```php
apiV1SuppliersGetSupplierByCodeGet($supplier_code): \Opsuite2\Model\Supplier
```

Returns a single Supplier with the specified code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SuppliersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier_code = 'supplier_code_example'; // string

try {
    $result = $apiInstance->apiV1SuppliersGetSupplierByCodeGet($supplier_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuppliersApi->apiV1SuppliersGetSupplierByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier_code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Supplier**](../Model/Supplier.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SuppliersPost()`

```php
apiV1SuppliersPost($supplier): \Opsuite2\Model\Supplier
```

Creates a new supplier.

Returns a 422 response code if a supplier already exists with the same account number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SuppliersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier = new \Opsuite2\Model\Supplier(); // \Opsuite2\Model\Supplier

try {
    $result = $apiInstance->apiV1SuppliersPost($supplier);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuppliersApi->apiV1SuppliersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier** | [**\Opsuite2\Model\Supplier**](../Model/Supplier.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Supplier**](../Model/Supplier.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSupplierById()`

```php
getSupplierById($supplier_id): \Opsuite2\Model\Supplier
```

Returns a single Supplier with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SuppliersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier_id = 56; // int

try {
    $result = $apiInstance->getSupplierById($supplier_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SuppliersApi->getSupplierById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Supplier**](../Model/Supplier.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
