# Opsuite2\SupplierItemsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet()**](SupplierItemsApi.md#apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet) | **GET** /api/v1/SupplierItems/GetSupplierItemBySupplierIdAndItemMasterId | Returns a single SupplierItem with the specified supplierId and itemMasterId. |
| [**apiV1SupplierItemsPatchMultipleSupplierItemsPatch()**](SupplierItemsApi.md#apiV1SupplierItemsPatchMultipleSupplierItemsPatch) | **PATCH** /api/v1/SupplierItems/PatchMultipleSupplierItems | Updates specified properties of multiple SupplierItems. |
| [**apiV1SupplierItemsPostMultipleSupplierItemsPost()**](SupplierItemsApi.md#apiV1SupplierItemsPostMultipleSupplierItemsPost) | **POST** /api/v1/SupplierItems/PostMultipleSupplierItems | Creates multiple new SupplierItems. |
| [**apiV1SupplierItemsSupplierItemIdDelete()**](SupplierItemsApi.md#apiV1SupplierItemsSupplierItemIdDelete) | **DELETE** /api/v1/SupplierItems/{supplierItemId} | Deletes a single SupplierItem by reference to id. |


## `apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet()`

```php
apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet($supplier_id, $item_master_id): \Opsuite2\Model\SupplierItem
```

Returns a single SupplierItem with the specified supplierId and itemMasterId.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SupplierItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier_id = 56; // int
$item_master_id = 56; // int

try {
    $result = $apiInstance->apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet($supplier_id, $item_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierItemsApi->apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier_id** | **int**|  | [optional] |
| **item_master_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\SupplierItem**](../Model/SupplierItem.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SupplierItemsPatchMultipleSupplierItemsPatch()`

```php
apiV1SupplierItemsPatchMultipleSupplierItemsPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple SupplierItems.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SupplierItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1SupplierItemsPatchMultipleSupplierItemsPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierItemsApi->apiV1SupplierItemsPatchMultipleSupplierItemsPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SupplierItemsPostMultipleSupplierItemsPost()`

```php
apiV1SupplierItemsPostMultipleSupplierItemsPost($supplier_item): \Opsuite2\Model\PostResponseSupplierItem[]
```

Creates multiple new SupplierItems.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SupplierItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier_item = array(new \Opsuite2\Model\SupplierItem()); // \Opsuite2\Model\SupplierItem[]

try {
    $result = $apiInstance->apiV1SupplierItemsPostMultipleSupplierItemsPost($supplier_item);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SupplierItemsApi->apiV1SupplierItemsPostMultipleSupplierItemsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier_item** | [**\Opsuite2\Model\SupplierItem[]**](../Model/SupplierItem.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseSupplierItem[]**](../Model/PostResponseSupplierItem.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SupplierItemsSupplierItemIdDelete()`

```php
apiV1SupplierItemsSupplierItemIdDelete($supplier_item_id)
```

Deletes a single SupplierItem by reference to id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SupplierItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier_item_id = 56; // int

try {
    $apiInstance->apiV1SupplierItemsSupplierItemIdDelete($supplier_item_id);
} catch (Exception $e) {
    echo 'Exception when calling SupplierItemsApi->apiV1SupplierItemsSupplierItemIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier_item_id** | **int**|  | |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
