# Opsuite2\SimpleTaxRatesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SimpleTaxRatesGet()**](SimpleTaxRatesApi.md#apiV1SimpleTaxRatesGet) | **GET** /api/v1/SimpleTaxRates | Returns an array of SimpleTaxRates. |
| [**apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet()**](SimpleTaxRatesApi.md#apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet) | **GET** /api/v1/SimpleTaxRates/GetSimpleTaxRateByCode | Returns a single SimpleTaxRate with the specified code. |
| [**apiV1SimpleTaxRatesIdPatch()**](SimpleTaxRatesApi.md#apiV1SimpleTaxRatesIdPatch) | **PATCH** /api/v1/SimpleTaxRates/{id} | Updates specified properties of a simple tax rate. |
| [**apiV1SimpleTaxRatesPost()**](SimpleTaxRatesApi.md#apiV1SimpleTaxRatesPost) | **POST** /api/v1/SimpleTaxRates | Creates a new simple tax rate. |
| [**getSimpleTaxRateById()**](SimpleTaxRatesApi.md#getSimpleTaxRateById) | **GET** /api/v1/SimpleTaxRates/{id} | Returns a single SimpleTaxRate with the specified id. |


## `apiV1SimpleTaxRatesGet()`

```php
apiV1SimpleTaxRatesGet($page_number, $page_size): \Opsuite2\Model\SimpleTaxRate[]
```

Returns an array of SimpleTaxRates.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SimpleTaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1SimpleTaxRatesGet($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SimpleTaxRatesApi->apiV1SimpleTaxRatesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\SimpleTaxRate[]**](../Model/SimpleTaxRate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet()`

```php
apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet($code): \Opsuite2\Model\SimpleTaxRate
```

Returns a single SimpleTaxRate with the specified code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SimpleTaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$code = 'code_example'; // string

try {
    $result = $apiInstance->apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet($code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SimpleTaxRatesApi->apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\SimpleTaxRate**](../Model/SimpleTaxRate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SimpleTaxRatesIdPatch()`

```php
apiV1SimpleTaxRatesIdPatch($id, $patch)
```

Updates specified properties of a simple tax rate.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SimpleTaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1SimpleTaxRatesIdPatch($id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling SimpleTaxRatesApi->apiV1SimpleTaxRatesIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SimpleTaxRatesPost()`

```php
apiV1SimpleTaxRatesPost($simple_tax_rate): \Opsuite2\Model\SimpleTaxRate
```

Creates a new simple tax rate.

Returns a 422 response code if a tax rate already exists with the same code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SimpleTaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$simple_tax_rate = new \Opsuite2\Model\SimpleTaxRate(); // \Opsuite2\Model\SimpleTaxRate

try {
    $result = $apiInstance->apiV1SimpleTaxRatesPost($simple_tax_rate);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SimpleTaxRatesApi->apiV1SimpleTaxRatesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **simple_tax_rate** | [**\Opsuite2\Model\SimpleTaxRate**](../Model/SimpleTaxRate.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\SimpleTaxRate**](../Model/SimpleTaxRate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSimpleTaxRateById()`

```php
getSimpleTaxRateById($id): \Opsuite2\Model\SimpleTaxRate
```

Returns a single SimpleTaxRate with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SimpleTaxRatesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int

try {
    $result = $apiInstance->getSimpleTaxRateById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SimpleTaxRatesApi->getSimpleTaxRateById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Opsuite2\Model\SimpleTaxRate**](../Model/SimpleTaxRate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
