# Opsuite2\SalesRepsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SalesRepsGet()**](SalesRepsApi.md#apiV1SalesRepsGet) | **GET** /api/v1/SalesReps | Returns an array of SalesReps that match the specified search criteria. |


## `apiV1SalesRepsGet()`

```php
apiV1SalesRepsGet($page_number, $page_size, $include_inactive): \Opsuite2\Model\SalesRep[]
```

Returns an array of SalesReps that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesRepsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$include_inactive = True; // bool

try {
    $result = $apiInstance->apiV1SalesRepsGet($page_number, $page_size, $include_inactive);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesRepsApi->apiV1SalesRepsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\SalesRep[]**](../Model/SalesRep.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
