# Opsuite2\SalesOrdersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1SalesOrdersGet()**](SalesOrdersApi.md#apiV1SalesOrdersGet) | **GET** /api/v1/SalesOrders | Returns an array of SalesOrders that match the specified search criteria. |
| [**apiV1SalesOrdersOrderIdClosedStatusGet()**](SalesOrdersApi.md#apiV1SalesOrdersOrderIdClosedStatusGet) | **GET** /api/v1/SalesOrders/{orderId}/ClosedStatus | Returns the closed status for the specified sales order. |
| [**apiV1SalesOrdersUpdateTrackingNumberPatch()**](SalesOrdersApi.md#apiV1SalesOrdersUpdateTrackingNumberPatch) | **PATCH** /api/v1/SalesOrders/UpdateTrackingNumber | Updates the shipping tracking number on the specified order |
| [**apiV2SalesOrdersGet()**](SalesOrdersApi.md#apiV2SalesOrdersGet) | **GET** /api/v2/SalesOrders | Returns an array of SalesOrders that match the specified search criteria. |
| [**createMultiLocationSalesOrderFromBasket()**](SalesOrdersApi.md#createMultiLocationSalesOrderFromBasket) | **POST** /api/v1/SalesOrders/CreateMultiLocationSalesOrderFromBasket | Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location |
| [**createSalesOrderFromBasket()**](SalesOrdersApi.md#createSalesOrderFromBasket) | **POST** /api/v1/SalesOrders/CreateSalesOrderFromBasket | Creates a new sales order from a stored basket of goods. |
| [**getSalesOrderByOrderId()**](SalesOrdersApi.md#getSalesOrderByOrderId) | **GET** /api/v1/SalesOrders/{orderId} | Returns the specified sales order transaction. |


## `apiV1SalesOrdersGet()`

```php
apiV1SalesOrdersGet($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator): \Opsuite2\Model\OrderTransaction[]
```

Returns an array of SalesOrders that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$order_transaction_type_id = 56; // int
$location_id = 56; // int
$order_status = 'order_status_example'; // string
$include_closed = True; // bool
$order_comment = 'order_comment_example'; // string
$order_comment_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$order_reference = 'order_reference_example'; // string
$order_reference_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum

try {
    $result = $apiInstance->apiV1SalesOrdersGet($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->apiV1SalesOrdersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |
| **order_transaction_type_id** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **order_status** | **string**|  | [optional] |
| **include_closed** | **bool**|  | [optional] |
| **order_comment** | **string**|  | [optional] |
| **order_comment_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **order_reference** | **string**|  | [optional] |
| **order_reference_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderTransaction[]**](../Model/OrderTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SalesOrdersOrderIdClosedStatusGet()`

```php
apiV1SalesOrdersOrderIdClosedStatusGet($order_id): \Opsuite2\Model\OrderClosedStatus
```

Returns the closed status for the specified sales order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int

try {
    $result = $apiInstance->apiV1SalesOrdersOrderIdClosedStatusGet($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->apiV1SalesOrdersOrderIdClosedStatusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\OrderClosedStatus**](../Model/OrderClosedStatus.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1SalesOrdersUpdateTrackingNumberPatch()`

```php
apiV1SalesOrdersUpdateTrackingNumberPatch($order_id, $tracking_number): \Opsuite2\Model\OrderClosedStatus
```

Updates the shipping tracking number on the specified order

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int | 
$tracking_number = 'tracking_number_example'; // string | 

try {
    $result = $apiInstance->apiV1SalesOrdersUpdateTrackingNumberPatch($order_id, $tracking_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->apiV1SalesOrdersUpdateTrackingNumberPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**|  | [optional] |
| **tracking_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderClosedStatus**](../Model/OrderClosedStatus.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2SalesOrdersGet()`

```php
apiV2SalesOrdersGet($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator): \Opsuite2\Model\OrderTransaction[]
```

Returns an array of SalesOrders that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$order_transaction_type_id = 56; // int
$location_id = 56; // int
$order_status = 'order_status_example'; // string
$include_closed = True; // bool
$order_comment = 'order_comment_example'; // string
$order_comment_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$order_reference = 'order_reference_example'; // string
$order_reference_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum

try {
    $result = $apiInstance->apiV2SalesOrdersGet($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->apiV2SalesOrdersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |
| **order_transaction_type_id** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **order_status** | **string**|  | [optional] |
| **include_closed** | **bool**|  | [optional] |
| **order_comment** | **string**|  | [optional] |
| **order_comment_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **order_reference** | **string**|  | [optional] |
| **order_reference_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderTransaction[]**](../Model/OrderTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createMultiLocationSalesOrderFromBasket()`

```php
createMultiLocationSalesOrderFromBasket($multi_location_sales_order_basket): \Opsuite2\Model\OrderTransaction
```

Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$multi_location_sales_order_basket = new \Opsuite2\Model\MultiLocationSalesOrderBasket(); // \Opsuite2\Model\MultiLocationSalesOrderBasket

try {
    $result = $apiInstance->createMultiLocationSalesOrderFromBasket($multi_location_sales_order_basket);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->createMultiLocationSalesOrderFromBasket: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **multi_location_sales_order_basket** | [**\Opsuite2\Model\MultiLocationSalesOrderBasket**](../Model/MultiLocationSalesOrderBasket.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderTransaction**](../Model/OrderTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createSalesOrderFromBasket()`

```php
createSalesOrderFromBasket($sales_order_basket): \Opsuite2\Model\OrderTransaction
```

Creates a new sales order from a stored basket of goods.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sales_order_basket = new \Opsuite2\Model\SalesOrderBasket(); // \Opsuite2\Model\SalesOrderBasket

try {
    $result = $apiInstance->createSalesOrderFromBasket($sales_order_basket);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->createSalesOrderFromBasket: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sales_order_basket** | [**\Opsuite2\Model\SalesOrderBasket**](../Model/SalesOrderBasket.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderTransaction**](../Model/OrderTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSalesOrderByOrderId()`

```php
getSalesOrderByOrderId($order_id): \Opsuite2\Model\OrderTransaction
```

Returns the specified sales order transaction.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\SalesOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int

try {
    $result = $apiInstance->getSalesOrderByOrderId($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrdersApi->getSalesOrderByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\OrderTransaction**](../Model/OrderTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
