# Opsuite2\RegistersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1RegistersGet()**](RegistersApi.md#apiV1RegistersGet) | **GET** /api/v1/Registers | Returns an array of Registers that match the specified search criteria. |
| [**apiV1RegistersGetRegisterByNumberAndLocationIdGet()**](RegistersApi.md#apiV1RegistersGetRegisterByNumberAndLocationIdGet) | **GET** /api/v1/Registers/GetRegisterByNumberAndLocationId | Returns a single Register with the specified number at the specified location. |
| [**getRegisterById()**](RegistersApi.md#getRegisterById) | **GET** /api/v1/Registers/{registerId} | Returns a single Register with the specified id. |


## `apiV1RegistersGet()`

```php
apiV1RegistersGet($page_number, $page_size, $location_id, $include_inactive): \Opsuite2\Model\Register[]
```

Returns an array of Registers that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$include_inactive = True; // bool

try {
    $result = $apiInstance->apiV1RegistersGet($page_number, $page_size, $location_id, $include_inactive);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->apiV1RegistersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\Register[]**](../Model/Register.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1RegistersGetRegisterByNumberAndLocationIdGet()`

```php
apiV1RegistersGetRegisterByNumberAndLocationIdGet($register_number, $location_id): \Opsuite2\Model\Register
```

Returns a single Register with the specified number at the specified location.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_number = 56; // int
$location_id = 56; // int

try {
    $result = $apiInstance->apiV1RegistersGetRegisterByNumberAndLocationIdGet($register_number, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->apiV1RegistersGetRegisterByNumberAndLocationIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **register_number** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\Register**](../Model/Register.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRegisterById()`

```php
getRegisterById($register_id): \Opsuite2\Model\Register
```

Returns a single Register with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_id = 56; // int

try {
    $result = $apiInstance->getRegisterById($register_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->getRegisterById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **register_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Register**](../Model/Register.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
