# Opsuite2\ReasonCodesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ReasonCodesGet()**](ReasonCodesApi.md#apiV1ReasonCodesGet) | **GET** /api/v1/ReasonCodes | Returns an array of Reason Codes that match the specified search criteria. |
| [**getReasonCodeById()**](ReasonCodesApi.md#getReasonCodeById) | **GET** /api/v1/ReasonCodes/{reasonCodeId} | Returns a single ReasonCode with the specified id. |


## `apiV1ReasonCodesGet()`

```php
apiV1ReasonCodesGet($page_number, $page_size, $include_inactive, $reason_code_type, $modified_date_range_start, $modified_date_range_end): \Opsuite2\Model\ReasonCode[]
```

Returns an array of Reason Codes that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ReasonCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$include_inactive = True; // bool
$reason_code_type = 'reason_code_type_example'; // string
$modified_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$modified_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1ReasonCodesGet($page_number, $page_size, $include_inactive, $reason_code_type, $modified_date_range_start, $modified_date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReasonCodesApi->apiV1ReasonCodesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |
| **reason_code_type** | **string**|  | [optional] |
| **modified_date_range_start** | **\DateTime**|  | [optional] |
| **modified_date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\ReasonCode[]**](../Model/ReasonCode.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReasonCodeById()`

```php
getReasonCodeById($reason_code_id): \Opsuite2\Model\ReasonCode
```

Returns a single ReasonCode with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ReasonCodesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$reason_code_id = 56; // int

try {
    $result = $apiInstance->getReasonCodeById($reason_code_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReasonCodesApi->getReasonCodeById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **reason_code_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ReasonCode**](../Model/ReasonCode.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
