# Opsuite2\PurchaseOrdersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet()**](PurchaseOrdersApi.md#apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrderByOrderNumber | Returns a PurchaseOrder for a given inventory control document order number. |
| [**apiV1PurchaseOrderGetPurchaseOrderGet()**](PurchaseOrdersApi.md#apiV1PurchaseOrderGetPurchaseOrderGet) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrder | Returns an array of PurchaseOrder that match the specified search criteria. |
| [**apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet()**](PurchaseOrdersApi.md#apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrderLinesById | Returns the lines on a Purchase Order. |
| [**apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet()**](PurchaseOrdersApi.md#apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrderLinesByOrderNumber | Returns the lines on a Purchase Order. |
| [**getPurchaseOrderById()**](PurchaseOrdersApi.md#getPurchaseOrderById) | **GET** /api/v1/PurchaseOrder/{inventoryControlDocumentId} | Returns a PurchaseOrder for a given inventory control document id. |


## `apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet()`

```php
apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet($order_number): \Opsuite2\Model\PurchaseOrder
```

Returns a PurchaseOrder for a given inventory control document order number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_number = 'order_number_example'; // string

try {
    $result = $apiInstance->apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet($order_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1PurchaseOrderGetPurchaseOrderGet()`

```php
apiV1PurchaseOrderGetPurchaseOrderGet($page_number, $page_size, $destination_location_id, $supplier_id, $order_number, $order_number_search_operator, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end): \Opsuite2\Model\PurchaseOrder[]
```

Returns an array of PurchaseOrder that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$destination_location_id = 56; // int
$supplier_id = 56; // int
$order_number = 'order_number_example'; // string
$order_number_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$date_created_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_created_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_placed_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_placed_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1PurchaseOrderGetPurchaseOrderGet($page_number, $page_size, $destination_location_id, $supplier_id, $order_number, $order_number_search_operator, $date_created_date_range_start, $date_created_date_range_end, $date_placed_date_range_start, $date_placed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->apiV1PurchaseOrderGetPurchaseOrderGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **destination_location_id** | **int**|  | [optional] |
| **supplier_id** | **int**|  | [optional] |
| **order_number** | **string**|  | [optional] |
| **order_number_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **date_created_date_range_start** | **\DateTime**|  | [optional] |
| **date_created_date_range_end** | **\DateTime**|  | [optional] |
| **date_placed_date_range_start** | **\DateTime**|  | [optional] |
| **date_placed_date_range_end** | **\DateTime**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\PurchaseOrder[]**](../Model/PurchaseOrder.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet()`

```php
apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet($page_number, $page_size, $inventory_control_document_id)
```

Returns the lines on a Purchase Order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$inventory_control_document_id = 56; // int

try {
    $apiInstance->apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet($page_number, $page_size, $inventory_control_document_id);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **inventory_control_document_id** | **int**|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet()`

```php
apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet($page_number, $page_size, $order_number)
```

Returns the lines on a Purchase Order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$order_number = 'order_number_example'; // string

try {
    $apiInstance->apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet($page_number, $page_size, $order_number);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **order_number** | **string**|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPurchaseOrderById()`

```php
getPurchaseOrderById($inventory_control_document_id): \Opsuite2\Model\PurchaseOrder
```

Returns a PurchaseOrder for a given inventory control document id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PurchaseOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_control_document_id = 56; // int

try {
    $result = $apiInstance->getPurchaseOrderById($inventory_control_document_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PurchaseOrdersApi->getPurchaseOrderById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_control_document_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\PurchaseOrder**](../Model/PurchaseOrder.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
