# Opsuite2\PromotionItemsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1PromotionItemsGet()**](PromotionItemsApi.md#apiV1PromotionItemsGet) | **GET** /api/v1/PromotionItems | Returns an array of Promotion Items that match the specified search criteria. |


## `apiV1PromotionItemsGet()`

```php
apiV1PromotionItemsGet($page_number, $page_size, $location_ids, $promotion_ids): \Opsuite2\Model\PromotionItem[]
```

Returns an array of Promotion Items that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PromotionItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_ids = array(56); // int[]
$promotion_ids = array(56); // int[]

try {
    $result = $apiInstance->apiV1PromotionItemsGet($page_number, $page_size, $location_ids, $promotion_ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionItemsApi->apiV1PromotionItemsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_ids** | [**int[]**](../Model/int.md)|  | [optional] |
| **promotion_ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PromotionItem[]**](../Model/PromotionItem.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
