# Opsuite2\PromotionHeadersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1PromotionHeadersGet()**](PromotionHeadersApi.md#apiV1PromotionHeadersGet) | **GET** /api/v1/PromotionHeaders | Returns an array of Promotion Headers that match the specified search criteria. |
| [**apiV1PromotionHeadersGetPromotionHeadersForItemGet()**](PromotionHeadersApi.md#apiV1PromotionHeadersGetPromotionHeadersForItemGet) | **GET** /api/v1/PromotionHeaders/GetPromotionHeadersForItem | Returns an array of Promotion Headers that could fire for the supplied item. |
| [**apiV1PromotionHeadersGetPromotionHeadersForItemsGet()**](PromotionHeadersApi.md#apiV1PromotionHeadersGetPromotionHeadersForItemsGet) | **GET** /api/v1/PromotionHeaders/GetPromotionHeadersForItems | Returns an array of Promotion Headers that could fire for the supplied item. |
| [**getPromotionHeaderById()**](PromotionHeadersApi.md#getPromotionHeaderById) | **GET** /api/v1/PromotionHeaders/{promotionId} | Returns a single PromotionHeader with the specified id. |


## `apiV1PromotionHeadersGet()`

```php
apiV1PromotionHeadersGet($page_number, $page_size, $include_inactive, $active_on, $date_range_start, $date_range_end, $modified_date_range_start, $modified_date_range_end): \Opsuite2\Model\PromotionHeader[]
```

Returns an array of Promotion Headers that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PromotionHeadersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$include_inactive = True; // bool
$active_on = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$modified_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$modified_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1PromotionHeadersGet($page_number, $page_size, $include_inactive, $active_on, $date_range_start, $date_range_end, $modified_date_range_start, $modified_date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionHeadersApi->apiV1PromotionHeadersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |
| **active_on** | **\DateTime**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |
| **modified_date_range_start** | **\DateTime**|  | [optional] |
| **modified_date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\PromotionHeader[]**](../Model/PromotionHeader.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1PromotionHeadersGetPromotionHeadersForItemGet()`

```php
apiV1PromotionHeadersGetPromotionHeadersForItemGet($page_number, $page_size, $location_id, $sku, $customer_id): \Opsuite2\Model\PromotionHeader[]
```

Returns an array of Promotion Headers that could fire for the supplied item.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PromotionHeadersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$sku = 'sku_example'; // string
$customer_id = 56; // int

try {
    $result = $apiInstance->apiV1PromotionHeadersGetPromotionHeadersForItemGet($page_number, $page_size, $location_id, $sku, $customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionHeadersApi->apiV1PromotionHeadersGetPromotionHeadersForItemGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **sku** | **string**|  | [optional] |
| **customer_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\PromotionHeader[]**](../Model/PromotionHeader.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1PromotionHeadersGetPromotionHeadersForItemsGet()`

```php
apiV1PromotionHeadersGetPromotionHeadersForItemsGet($page_number, $page_size, $location_id, $skus, $customer_id): \Opsuite2\Model\PromotionHeadersByItem[]
```

Returns an array of Promotion Headers that could fire for the supplied item.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PromotionHeadersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$skus = array('skus_example'); // string[]
$customer_id = 56; // int

try {
    $result = $apiInstance->apiV1PromotionHeadersGetPromotionHeadersForItemsGet($page_number, $page_size, $location_id, $skus, $customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionHeadersApi->apiV1PromotionHeadersGetPromotionHeadersForItemsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **skus** | [**string[]**](../Model/string.md)|  | [optional] |
| **customer_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\PromotionHeadersByItem[]**](../Model/PromotionHeadersByItem.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPromotionHeaderById()`

```php
getPromotionHeaderById($promotion_id): \Opsuite2\Model\PromotionHeader
```

Returns a single PromotionHeader with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PromotionHeadersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$promotion_id = 56; // int

try {
    $result = $apiInstance->getPromotionHeaderById($promotion_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionHeadersApi->getPromotionHeaderById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **promotion_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\PromotionHeader**](../Model/PromotionHeader.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
