# Opsuite2\PersonTitlesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1PersonTitlesGet()**](PersonTitlesApi.md#apiV1PersonTitlesGet) | **GET** /api/v1/PersonTitles | Returns an array of Person Titles. |


## `apiV1PersonTitlesGet()`

```php
apiV1PersonTitlesGet($page_number, $page_size): \Opsuite2\Model\PersonTitle[]
```

Returns an array of Person Titles.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\PersonTitlesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1PersonTitlesGet($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PersonTitlesApi->apiV1PersonTitlesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\PersonTitle[]**](../Model/PersonTitle.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
