# Opsuite2\OrderDetailsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1OrderDetailsDispatchOrderPost()**](OrderDetailsApi.md#apiV1OrderDetailsDispatchOrderPost) | **POST** /api/v1/OrderDetails/DispatchOrder | Dispatch a customer order. |
| [**apiV1OrderDetailsGetOrderDetailsGet()**](OrderDetailsApi.md#apiV1OrderDetailsGetOrderDetailsGet) | **GET** /api/v1/OrderDetails/GetOrderDetails | Returns an array of OrderDetails that match the specified search criteria. |
| [**getOrderDetailsById()**](OrderDetailsApi.md#getOrderDetailsById) | **GET** /api/v1/OrderDetails/{orderId} | Returns a OrderDetails for a given inventory control document id. |


## `apiV1OrderDetailsDispatchOrderPost()`

```php
apiV1OrderDetailsDispatchOrderPost($order_details_update): \Opsuite2\Model\OrderDetailsUpdate
```

Dispatch a customer order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\OrderDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_details_update = new \Opsuite2\Model\OrderDetailsUpdate(); // \Opsuite2\Model\OrderDetailsUpdate

try {
    $result = $apiInstance->apiV1OrderDetailsDispatchOrderPost($order_details_update);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderDetailsApi->apiV1OrderDetailsDispatchOrderPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_details_update** | [**\Opsuite2\Model\OrderDetailsUpdate**](../Model/OrderDetailsUpdate.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderDetailsUpdate**](../Model/OrderDetailsUpdate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1OrderDetailsGetOrderDetailsGet()`

```php
apiV1OrderDetailsGetOrderDetailsGet($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator): \Opsuite2\Model\OrderDetails[]
```

Returns an array of OrderDetails that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\OrderDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$order_transaction_type_id = 56; // int
$location_id = 56; // int
$order_status = 'order_status_example'; // string
$include_closed = True; // bool
$order_comment = 'order_comment_example'; // string
$order_comment_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$order_reference = 'order_reference_example'; // string
$order_reference_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum

try {
    $result = $apiInstance->apiV1OrderDetailsGetOrderDetailsGet($page_number, $page_size, $last_updated_date_range_start, $last_updated_date_range_end, $order_transaction_type_id, $location_id, $order_status, $include_closed, $order_comment, $order_comment_search_operator, $order_reference, $order_reference_search_operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderDetailsApi->apiV1OrderDetailsGetOrderDetailsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |
| **order_transaction_type_id** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **order_status** | **string**|  | [optional] |
| **include_closed** | **bool**|  | [optional] |
| **order_comment** | **string**|  | [optional] |
| **order_comment_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **order_reference** | **string**|  | [optional] |
| **order_reference_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\OrderDetails[]**](../Model/OrderDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderDetailsById()`

```php
getOrderDetailsById($order_id): \Opsuite2\Model\OrderDetails
```

Returns a OrderDetails for a given inventory control document id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\OrderDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_id = 56; // int

try {
    $result = $apiInstance->getOrderDetailsById($order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderDetailsApi->getOrderDetailsById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\OrderDetails**](../Model/OrderDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
