# Opsuite2\MatrixMastersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1MatrixMastersGet()**](MatrixMastersApi.md#apiV1MatrixMastersGet) | **GET** /api/v1/MatrixMasters | Returns an array of Matrix Masters for a given location |
| [**apiV1MatrixMastersGetMatrixMasterBySkuGet()**](MatrixMastersApi.md#apiV1MatrixMastersGetMatrixMasterBySkuGet) | **GET** /api/v1/MatrixMasters/GetMatrixMasterBySku | Returns a single MatrixMaster with the specified sku. |
| [**getMatrixMasterById()**](MatrixMastersApi.md#getMatrixMasterById) | **GET** /api/v1/MatrixMasters/{matrixMasterId} | Returns a single MatrixMaster with the specified id. |


## `apiV1MatrixMastersGet()`

```php
apiV1MatrixMastersGet($page_number, $page_size, $location_id): \Opsuite2\Model\MatrixMaster[]
```

Returns an array of Matrix Masters for a given location

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\MatrixMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int

try {
    $result = $apiInstance->apiV1MatrixMastersGet($page_number, $page_size, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MatrixMastersApi->apiV1MatrixMastersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\MatrixMaster[]**](../Model/MatrixMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1MatrixMastersGetMatrixMasterBySkuGet()`

```php
apiV1MatrixMastersGetMatrixMasterBySkuGet($sku): \Opsuite2\Model\MatrixMaster
```

Returns a single MatrixMaster with the specified sku.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\MatrixMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV1MatrixMastersGetMatrixMasterBySkuGet($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MatrixMastersApi->apiV1MatrixMastersGetMatrixMasterBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\MatrixMaster**](../Model/MatrixMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMatrixMasterById()`

```php
getMatrixMasterById($matrix_master_id): \Opsuite2\Model\MatrixMaster
```

Returns a single MatrixMaster with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\MatrixMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$matrix_master_id = 56; // int

try {
    $result = $apiInstance->getMatrixMasterById($matrix_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MatrixMastersApi->getMatrixMasterById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **matrix_master_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\MatrixMaster**](../Model/MatrixMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
