# Opsuite2\LoyaltyCardsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1LoyaltyCardsCreateLoyaltyCardPost()**](LoyaltyCardsApi.md#apiV1LoyaltyCardsCreateLoyaltyCardPost) | **POST** /api/v1/LoyaltyCards/CreateLoyaltyCard | Creates a loyalty card |
| [**apiV1LoyaltyCardsGetLoyaltyCardByNumberGet()**](LoyaltyCardsApi.md#apiV1LoyaltyCardsGetLoyaltyCardByNumberGet) | **GET** /api/v1/LoyaltyCards/GetLoyaltyCardByNumber | Returns a single LoyaltyCard with the specified number. |
| [**apiV1LoyaltyCardsLoyaltyCardIdPatch()**](LoyaltyCardsApi.md#apiV1LoyaltyCardsLoyaltyCardIdPatch) | **PATCH** /api/v1/LoyaltyCards/{loyaltyCardId} | Updates specified properties of a loyalty card. |
| [**getLoyaltyCardById()**](LoyaltyCardsApi.md#getLoyaltyCardById) | **GET** /api/v1/LoyaltyCards/{loyaltyCardId} | Returns a single LoyaltyCard with the specified id. |


## `apiV1LoyaltyCardsCreateLoyaltyCardPost()`

```php
apiV1LoyaltyCardsCreateLoyaltyCardPost($loyalty_card): \Opsuite2\Model\LoyaltyCard
```

Creates a loyalty card

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LoyaltyCardsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$loyalty_card = new \Opsuite2\Model\LoyaltyCard(); // \Opsuite2\Model\LoyaltyCard

try {
    $result = $apiInstance->apiV1LoyaltyCardsCreateLoyaltyCardPost($loyalty_card);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LoyaltyCardsApi->apiV1LoyaltyCardsCreateLoyaltyCardPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **loyalty_card** | [**\Opsuite2\Model\LoyaltyCard**](../Model/LoyaltyCard.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\LoyaltyCard**](../Model/LoyaltyCard.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1LoyaltyCardsGetLoyaltyCardByNumberGet()`

```php
apiV1LoyaltyCardsGetLoyaltyCardByNumberGet($card_number): \Opsuite2\Model\LoyaltyCard
```

Returns a single LoyaltyCard with the specified number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LoyaltyCardsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$card_number = 'card_number_example'; // string

try {
    $result = $apiInstance->apiV1LoyaltyCardsGetLoyaltyCardByNumberGet($card_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LoyaltyCardsApi->apiV1LoyaltyCardsGetLoyaltyCardByNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **card_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\LoyaltyCard**](../Model/LoyaltyCard.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1LoyaltyCardsLoyaltyCardIdPatch()`

```php
apiV1LoyaltyCardsLoyaltyCardIdPatch($loyalty_card_id, $patch)
```

Updates specified properties of a loyalty card.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LoyaltyCardsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$loyalty_card_id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1LoyaltyCardsLoyaltyCardIdPatch($loyalty_card_id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling LoyaltyCardsApi->apiV1LoyaltyCardsLoyaltyCardIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **loyalty_card_id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLoyaltyCardById()`

```php
getLoyaltyCardById($loyalty_card_id): \Opsuite2\Model\LoyaltyCard
```

Returns a single LoyaltyCard with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LoyaltyCardsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$loyalty_card_id = 56; // int

try {
    $result = $apiInstance->getLoyaltyCardById($loyalty_card_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LoyaltyCardsApi->getLoyaltyCardById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **loyalty_card_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\LoyaltyCard**](../Model/LoyaltyCard.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
