# Opsuite2\LocationsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1LocationsGet()**](LocationsApi.md#apiV1LocationsGet) | **GET** /api/v1/Locations | Returns an array of Locations.  NOTE: The result is cached for an hour after the first call. Changes made to  any location in that time won&#39;t be returned by any calls to this  method within that hour. |
| [**apiV1LocationsGetLocationByCodeGet()**](LocationsApi.md#apiV1LocationsGetLocationByCodeGet) | **GET** /api/v1/Locations/GetLocationByCode | Returns a single Location with the specified code.  NOTE: The result is cached for an hour after the first call. Changes made to  any location in that time won&#39;t be returned by any calls to this  method within that hour. |


## `apiV1LocationsGet()`

```php
apiV1LocationsGet($page_number, $page_size): \Opsuite2\Model\Location[]
```

Returns an array of Locations.  NOTE: The result is cached for an hour after the first call. Changes made to  any location in that time won't be returned by any calls to this  method within that hour.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1LocationsGet($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->apiV1LocationsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\Location[]**](../Model/Location.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1LocationsGetLocationByCodeGet()`

```php
apiV1LocationsGetLocationByCodeGet($location_code): \Opsuite2\Model\Location
```

Returns a single Location with the specified code.  NOTE: The result is cached for an hour after the first call. Changes made to  any location in that time won't be returned by any calls to this  method within that hour.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LocationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_code = 'location_code_example'; // string

try {
    $result = $apiInstance->apiV1LocationsGetLocationByCodeGet($location_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationsApi->apiV1LocationsGetLocationByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Location**](../Model/Location.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
