# Opsuite2\LocationGroupsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1LocationGroupsGet()**](LocationGroupsApi.md#apiV1LocationGroupsGet) | **GET** /api/v1/LocationGroups | Returns an array of Location Groups.  NOTE: The result is cached for an hour after the first call. Changes made to  any location group in that time won&#39;t be returned by any calls to this  method within that hour. |


## `apiV1LocationGroupsGet()`

```php
apiV1LocationGroupsGet($page_number, $page_size): \Opsuite2\Model\LocationGroup[]
```

Returns an array of Location Groups.  NOTE: The result is cached for an hour after the first call. Changes made to  any location group in that time won't be returned by any calls to this  method within that hour.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\LocationGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1LocationGroupsGet($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LocationGroupsApi->apiV1LocationGroupsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\LocationGroup[]**](../Model/LocationGroup.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
