# Opsuite2\ItemsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemsGetItemByLocationIdAndProductCodeGet()**](ItemsApi.md#apiV1ItemsGetItemByLocationIdAndProductCodeGet) | **GET** /api/v1/Items/GetItemByLocationIdAndProductCode | Returns a single Item with the specified location id and product code.  Product code can be the item sku, barcode number, or any of an items&#39;s alias skus. |
| [**apiV1ItemsItemLocationDetailIdItemQuestionsGet()**](ItemsApi.md#apiV1ItemsItemLocationDetailIdItemQuestionsGet) | **GET** /api/v1/Items/{itemLocationDetailId}/ItemQuestions | Returns an array of Questions associated with the item with the specified itemLocationDetailId |


## `apiV1ItemsGetItemByLocationIdAndProductCodeGet()`

```php
apiV1ItemsGetItemByLocationIdAndProductCodeGet($location_id, $sku): \Opsuite2\Model\Item
```

Returns a single Item with the specified location id and product code.  Product code can be the item sku, barcode number, or any of an items's alias skus.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_id = 56; // int
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV1ItemsGetItemByLocationIdAndProductCodeGet($location_id, $sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemsApi->apiV1ItemsGetItemByLocationIdAndProductCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_id** | **int**|  | [optional] |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Item**](../Model/Item.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemsItemLocationDetailIdItemQuestionsGet()`

```php
apiV1ItemsItemLocationDetailIdItemQuestionsGet($item_location_detail_id): \Opsuite2\Model\ItemQuestion[]
```

Returns an array of Questions associated with the item with the specified itemLocationDetailId

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_location_detail_id = 56; // int

try {
    $result = $apiInstance->apiV1ItemsItemLocationDetailIdItemQuestionsGet($item_location_detail_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemsApi->apiV1ItemsItemLocationDetailIdItemQuestionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_location_detail_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemQuestion[]**](../Model/ItemQuestion.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
