# Opsuite2\ItemMastersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemMastersGet()**](ItemMastersApi.md#apiV1ItemMastersGet) | **GET** /api/v1/ItemMasters | Returns an array of ItemMasters that match the specified search criteria. |
| [**apiV1ItemMastersGetItemMasterBySkuGet()**](ItemMastersApi.md#apiV1ItemMastersGetItemMasterBySkuGet) | **GET** /api/v1/ItemMasters/GetItemMasterBySku | Returns a single ItemMaster with the specified sku. |
| [**apiV1ItemMastersPatchMultipleItemMastersPatch()**](ItemMastersApi.md#apiV1ItemMastersPatchMultipleItemMastersPatch) | **PATCH** /api/v1/ItemMasters/PatchMultipleItemMasters | Updates specified properties of multiple item masters. |
| [**apiV1ItemMastersPost()**](ItemMastersApi.md#apiV1ItemMastersPost) | **POST** /api/v1/ItemMasters | Creates a new item master. |
| [**apiV1ItemMastersPostMultipleItemMastersPost()**](ItemMastersApi.md#apiV1ItemMastersPostMultipleItemMastersPost) | **POST** /api/v1/ItemMasters/PostMultipleItemMasters | Creates multiple new item masters. |
| [**getItemMasterById()**](ItemMastersApi.md#getItemMasterById) | **GET** /api/v1/ItemMasters/{itemMasterId} | Returns a single ItemMaster with the specified id. |


## `apiV1ItemMastersGet()`

```php
apiV1ItemMastersGet($page_number, $page_size, $item_type_id): \Opsuite2\Model\ItemMaster[]
```

Returns an array of ItemMasters that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$item_type_id = 56; // int

try {
    $result = $apiInstance->apiV1ItemMastersGet($page_number, $page_size, $item_type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMastersApi->apiV1ItemMastersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **item_type_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemMaster[]**](../Model/ItemMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMastersGetItemMasterBySkuGet()`

```php
apiV1ItemMastersGetItemMasterBySkuGet($sku): \Opsuite2\Model\ItemMaster
```

Returns a single ItemMaster with the specified sku.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV1ItemMastersGetItemMasterBySkuGet($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMastersApi->apiV1ItemMastersGetItemMasterBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemMaster**](../Model/ItemMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMastersPatchMultipleItemMastersPatch()`

```php
apiV1ItemMastersPatchMultipleItemMastersPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple item masters.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1ItemMastersPatchMultipleItemMastersPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMastersApi->apiV1ItemMastersPatchMultipleItemMastersPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMastersPost()`

```php
apiV1ItemMastersPost($item_master): \Opsuite2\Model\ItemMaster
```

Creates a new item master.

Returns the newly created item master.  Returns a 422 response code if an item master already exists with the same sku.                NOTE: Doesn't create any item location detail records even if the \"Auo Add Item To All Active Locations\"  option is set in OpSuite. To create the items at locations call api/v1/ItemLocationDetails/PostMultipleItemLocationDetails

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master = new \Opsuite2\Model\ItemMaster(); // \Opsuite2\Model\ItemMaster

try {
    $result = $apiInstance->apiV1ItemMastersPost($item_master);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMastersApi->apiV1ItemMastersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master** | [**\Opsuite2\Model\ItemMaster**](../Model/ItemMaster.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemMaster**](../Model/ItemMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMastersPostMultipleItemMastersPost()`

```php
apiV1ItemMastersPostMultipleItemMastersPost($item_master): \Opsuite2\Model\PostResponseItemMaster[]
```

Creates multiple new item masters.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.    NOTE: Doesn't create any item location detail records even if the \"Auo Add Item To All Active Locations\"  option is set in OpSuite. To create the items at locations call api/v1/ItemLocationDetails/PostMultipleItemLocationDetails

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master = array(new \Opsuite2\Model\ItemMaster()); // \Opsuite2\Model\ItemMaster[]

try {
    $result = $apiInstance->apiV1ItemMastersPostMultipleItemMastersPost($item_master);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMastersApi->apiV1ItemMastersPostMultipleItemMastersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master** | [**\Opsuite2\Model\ItemMaster[]**](../Model/ItemMaster.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseItemMaster[]**](../Model/PostResponseItemMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getItemMasterById()`

```php
getItemMasterById($item_master_id): \Opsuite2\Model\ItemMaster
```

Returns a single ItemMaster with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMastersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master_id = 56; // int

try {
    $result = $apiInstance->getItemMasterById($item_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMastersApi->getItemMasterById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemMaster**](../Model/ItemMaster.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
