# Opsuite2\ItemMasterAttributesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet()**](ItemMasterAttributesApi.md#apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet) | **GET** /api/v1/ItemMasterAttributes/GetItemMasterAttributeGroups | Returns the list of item master attribute groups. |
| [**apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet()**](ItemMasterAttributesApi.md#apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet) | **GET** /api/v1/ItemMasterAttributes/GetItemMasterAttributesBySku | Returns a list of attributes for the ItemMaster with the specified sku. |
| [**apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet()**](ItemMasterAttributesApi.md#apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet) | **GET** /api/v1/ItemMasterAttributes/GetItemMastersWithAttributesByIds | Returns a list item masters with attributes for the ItemMaster with the specified ids. |
| [**apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet()**](ItemMasterAttributesApi.md#apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet) | **GET** /api/v1/ItemMasterAttributes/GetItemMastersWithAttributesBySkus | Returns a list item masters with attributes for the ItemMaster with the specified skus. |
| [**getItemMasterAttributesById()**](ItemMasterAttributesApi.md#getItemMasterAttributesById) | **GET** /api/v1/ItemMasterAttributes/{itemMasterId} | Returns a list of attributes for the ItemMaster with the specified id. |


## `apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet()`

```php
apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet(): \Opsuite2\Model\AttributeGroupItemMasterAttribute[]
```

Returns the list of item master attribute groups.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMasterAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMasterAttributesApi->apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Opsuite2\Model\AttributeGroupItemMasterAttribute[]**](../Model/AttributeGroupItemMasterAttribute.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet()`

```php
apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet($sku): \Opsuite2\Model\ItemMasterAttribute[]
```

Returns a list of attributes for the ItemMaster with the specified sku.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMasterAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMasterAttributesApi->apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemMasterAttribute[]**](../Model/ItemMasterAttribute.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet()`

```php
apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet($ids): \Opsuite2\Model\ItemMasterWithAttributes[]
```

Returns a list item masters with attributes for the ItemMaster with the specified ids.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMasterAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$ids = array(56); // int[]

try {
    $result = $apiInstance->apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet($ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMasterAttributesApi->apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemMasterWithAttributes[]**](../Model/ItemMasterWithAttributes.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet()`

```php
apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet($skus): \Opsuite2\Model\ItemMasterWithAttributes[]
```

Returns a list item masters with attributes for the ItemMaster with the specified skus.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMasterAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$skus = array('skus_example'); // string[]

try {
    $result = $apiInstance->apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet($skus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMasterAttributesApi->apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **skus** | [**string[]**](../Model/string.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemMasterWithAttributes[]**](../Model/ItemMasterWithAttributes.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getItemMasterAttributesById()`

```php
getItemMasterAttributesById($item_master_id): \Opsuite2\Model\ItemMasterAttribute[]
```

Returns a list of attributes for the ItemMaster with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemMasterAttributesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master_id = 56; // int

try {
    $result = $apiInstance->getItemMasterAttributesById($item_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemMasterAttributesApi->getItemMasterAttributesById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemMasterAttribute[]**](../Model/ItemMasterAttribute.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
