# Opsuite2\ItemLocationDetailsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndItemMasterId | Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId |
| [**apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndProductCode | Returns a single ItemLocationDetail with the specified LocationId and product code |
| [**apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndSku | Returns a single ItemLocationDetail with the specified LocationId and sku |
| [**apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailsByLocationIdAndSkuList | Returns a list ItemLocationDetails with the specified LocationId and skus |
| [**apiV1ItemLocationDetailsGetItemLocationDetailsGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsGetItemLocationDetailsGet) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetails | Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters |
| [**apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailsModifiedSinceSpecifiedDate | Returns an array of ItemLocationDetails that have been modified since the specified date |
| [**apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet) | **GET** /api/v1/ItemLocationDetails/{itemLocationDetailId}/ItemQuestions | Returns an array of Questions associated with the specified ItemLocationDetail. |
| [**apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch) | **PATCH** /api/v1/ItemLocationDetails/PatchMultipleItemLocationDetails | Updates specified properties of multiple ItemLocationDetails. |
| [**apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost()**](ItemLocationDetailsApi.md#apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost) | **POST** /api/v1/ItemLocationDetails/PostMultipleItemLocationDetails | Creates multiple new item location details. |


## `apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet()`

```php
apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet($location_id, $item_master_id): \Opsuite2\Model\ItemLocationDetail
```

Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_id = 56; // int
$item_master_id = 56; // int

try {
    $result = $apiInstance->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet($location_id, $item_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_id** | **int**|  | [optional] |
| **item_master_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemLocationDetail**](../Model/ItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet()`

```php
apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet($location_id, $product_code): \Opsuite2\Model\ItemLocationDetail
```

Returns a single ItemLocationDetail with the specified LocationId and product code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_id = 56; // int
$product_code = 'product_code_example'; // string

try {
    $result = $apiInstance->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet($location_id, $product_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_id** | **int**|  | [optional] |
| **product_code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemLocationDetail**](../Model/ItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet()`

```php
apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet($location_id, $sku): \Opsuite2\Model\ItemLocationDetail
```

Returns a single ItemLocationDetail with the specified LocationId and sku

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_id = 56; // int
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet($location_id, $sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_id** | **int**|  | [optional] |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemLocationDetail**](../Model/ItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet()`

```php
apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet($location_id, $skus): \Opsuite2\Model\ItemLocationDetail[]
```

Returns a list ItemLocationDetails with the specified LocationId and skus

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_id = 56; // int
$skus = array('skus_example'); // string[]

try {
    $result = $apiInstance->apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet($location_id, $skus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_id** | **int**|  | [optional] |
| **skus** | [**string[]**](../Model/string.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemLocationDetail[]**](../Model/ItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsGetItemLocationDetailsGet()`

```php
apiV1ItemLocationDetailsGetItemLocationDetailsGet($page_number, $page_size, $location_id, $web_item, $last_updated): \Opsuite2\Model\ItemLocationDetail[]
```

Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$web_item = True; // bool
$last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1ItemLocationDetailsGetItemLocationDetailsGet($page_number, $page_size, $location_id, $web_item, $last_updated);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsGetItemLocationDetailsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **web_item** | **bool**|  | [optional] |
| **last_updated** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemLocationDetail[]**](../Model/ItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet()`

```php
apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet($page_number, $page_size, $specified_date): \Opsuite2\Model\ItemLocationDetail[]
```

Returns an array of ItemLocationDetails that have been modified since the specified date

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$specified_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet($page_number, $page_size, $specified_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **specified_date** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemLocationDetail[]**](../Model/ItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet()`

```php
apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet($item_location_detail_id): \Opsuite2\Model\ItemQuestion[]
```

Returns an array of Questions associated with the specified ItemLocationDetail.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_location_detail_id = 56; // int

try {
    $result = $apiInstance->apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet($item_location_detail_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_location_detail_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemQuestion[]**](../Model/ItemQuestion.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch()`

```php
apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple ItemLocationDetails.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost()`

```php
apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost($item_location_detail): \Opsuite2\Model\PostResponseItemLocationDetail[]
```

Creates multiple new item location details.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemLocationDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_location_detail = array(new \Opsuite2\Model\ItemLocationDetail()); // \Opsuite2\Model\ItemLocationDetail[]

try {
    $result = $apiInstance->apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost($item_location_detail);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemLocationDetailsApi->apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_location_detail** | [**\Opsuite2\Model\ItemLocationDetail[]**](../Model/ItemLocationDetail.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseItemLocationDetail[]**](../Model/PostResponseItemLocationDetail.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
