# Opsuite2\ItemDetailsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemDetailsGetItemDetailsByAttributeGet()**](ItemDetailsApi.md#apiV1ItemDetailsGetItemDetailsByAttributeGet) | **GET** /api/v1/ItemDetails/GetItemDetailsByAttribute | Returns a list of ItemDetails that have the specified attribute code or description |
| [**apiV1ItemDetailsGetItemDetailsByIdListGet()**](ItemDetailsApi.md#apiV1ItemDetailsGetItemDetailsByIdListGet) | **GET** /api/v1/ItemDetails/GetItemDetailsByIdList | Returns a list of ItemDetails for the specified list of item master ids. |
| [**apiV1ItemDetailsGetItemDetailsBySkuGet()**](ItemDetailsApi.md#apiV1ItemDetailsGetItemDetailsBySkuGet) | **GET** /api/v1/ItemDetails/GetItemDetailsBySku | Returns a single ItemDetails with the specified sku. |
| [**apiV1ItemDetailsGetItemDetailsBySkuListGet()**](ItemDetailsApi.md#apiV1ItemDetailsGetItemDetailsBySkuListGet) | **GET** /api/v1/ItemDetails/GetItemDetailsBySkuList | Returns a list of ItemDetails for the specified list of skus. |
| [**apiV1ItemDetailsGetItemDetailsGet()**](ItemDetailsApi.md#apiV1ItemDetailsGetItemDetailsGet) | **GET** /api/v1/ItemDetails/GetItemDetails | Returns a list of ItemDetails modified since the supplied date |
| [**apiV2ItemDetailsGetItemDetailsByAttributeGet()**](ItemDetailsApi.md#apiV2ItemDetailsGetItemDetailsByAttributeGet) | **GET** /api/v2/ItemDetails/GetItemDetailsByAttribute | Returns a list of ItemDetails that have the specified attribute code or description |
| [**apiV2ItemDetailsGetItemDetailsByIdListGet()**](ItemDetailsApi.md#apiV2ItemDetailsGetItemDetailsByIdListGet) | **GET** /api/v2/ItemDetails/GetItemDetailsByIdList | Returns a list of ItemDetails for the specified list of item master ids. |
| [**apiV2ItemDetailsGetItemDetailsBySkuGet()**](ItemDetailsApi.md#apiV2ItemDetailsGetItemDetailsBySkuGet) | **GET** /api/v2/ItemDetails/GetItemDetailsBySku | Returns a single ItemDetails with the specified sku. |
| [**apiV2ItemDetailsGetItemDetailsBySkuListGet()**](ItemDetailsApi.md#apiV2ItemDetailsGetItemDetailsBySkuListGet) | **GET** /api/v2/ItemDetails/GetItemDetailsBySkuList | Returns a list of ItemDetails for the specified list of skus. |
| [**apiV2ItemDetailsGetItemDetailsGet()**](ItemDetailsApi.md#apiV2ItemDetailsGetItemDetailsGet) | **GET** /api/v2/ItemDetails/GetItemDetails | Returns a list of ItemDetails modified since the supplied date |
| [**apiV2ItemDetailsItemMasterIdGet()**](ItemDetailsApi.md#apiV2ItemDetailsItemMasterIdGet) | **GET** /api/v2/ItemDetails/{itemMasterId} | Returns a single ItemDetails with the specified item master id |
| [**getItemDetails()**](ItemDetailsApi.md#getItemDetails) | **GET** /api/v1/ItemDetails/{itemMasterId} | Returns a single ItemDetails with the specified item master id |


## `apiV1ItemDetailsGetItemDetailsByAttributeGet()`

```php
apiV1ItemDetailsGetItemDetailsByAttributeGet($page_number, $page_size, $attribute): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails that have the specified attribute code or description

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$attribute = 'attribute_example'; // string

try {
    $result = $apiInstance->apiV1ItemDetailsGetItemDetailsByAttributeGet($page_number, $page_size, $attribute);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV1ItemDetailsGetItemDetailsByAttributeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **attribute** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemDetailsGetItemDetailsByIdListGet()`

```php
apiV1ItemDetailsGetItemDetailsByIdListGet($ids): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails for the specified list of item master ids.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$ids = array(56); // int[]

try {
    $result = $apiInstance->apiV1ItemDetailsGetItemDetailsByIdListGet($ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV1ItemDetailsGetItemDetailsByIdListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemDetailsGetItemDetailsBySkuGet()`

```php
apiV1ItemDetailsGetItemDetailsBySkuGet($sku): \Opsuite2\Model\ItemDetails
```

Returns a single ItemDetails with the specified sku.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV1ItemDetailsGetItemDetailsBySkuGet($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV1ItemDetailsGetItemDetailsBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemDetailsGetItemDetailsBySkuListGet()`

```php
apiV1ItemDetailsGetItemDetailsBySkuListGet($skus): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails for the specified list of skus.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$skus = array('skus_example'); // string[]

try {
    $result = $apiInstance->apiV1ItemDetailsGetItemDetailsBySkuListGet($skus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV1ItemDetailsGetItemDetailsBySkuListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **skus** | [**string[]**](../Model/string.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemDetailsGetItemDetailsGet()`

```php
apiV1ItemDetailsGetItemDetailsGet($page_number, $page_size, $specified_date): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails modified since the supplied date

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$specified_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1ItemDetailsGetItemDetailsGet($page_number, $page_size, $specified_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV1ItemDetailsGetItemDetailsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **specified_date** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ItemDetailsGetItemDetailsByAttributeGet()`

```php
apiV2ItemDetailsGetItemDetailsByAttributeGet($page_number, $page_size, $attribute, $include_inactive): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails that have the specified attribute code or description

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$attribute = 'attribute_example'; // string
$include_inactive = True; // bool

try {
    $result = $apiInstance->apiV2ItemDetailsGetItemDetailsByAttributeGet($page_number, $page_size, $attribute, $include_inactive);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV2ItemDetailsGetItemDetailsByAttributeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **attribute** | **string**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ItemDetailsGetItemDetailsByIdListGet()`

```php
apiV2ItemDetailsGetItemDetailsByIdListGet($ids): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails for the specified list of item master ids.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$ids = array(56); // int[]

try {
    $result = $apiInstance->apiV2ItemDetailsGetItemDetailsByIdListGet($ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV2ItemDetailsGetItemDetailsByIdListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ItemDetailsGetItemDetailsBySkuGet()`

```php
apiV2ItemDetailsGetItemDetailsBySkuGet($sku): \Opsuite2\Model\ItemDetails
```

Returns a single ItemDetails with the specified sku.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->apiV2ItemDetailsGetItemDetailsBySkuGet($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV2ItemDetailsGetItemDetailsBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ItemDetailsGetItemDetailsBySkuListGet()`

```php
apiV2ItemDetailsGetItemDetailsBySkuListGet($skus): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails for the specified list of skus.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$skus = array('skus_example'); // string[]

try {
    $result = $apiInstance->apiV2ItemDetailsGetItemDetailsBySkuListGet($skus);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV2ItemDetailsGetItemDetailsBySkuListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **skus** | [**string[]**](../Model/string.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ItemDetailsGetItemDetailsGet()`

```php
apiV2ItemDetailsGetItemDetailsGet($page_number, $page_size, $specified_date, $include_inactive): \Opsuite2\Model\ItemDetails[]
```

Returns a list of ItemDetails modified since the supplied date

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$specified_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$include_inactive = True; // bool

try {
    $result = $apiInstance->apiV2ItemDetailsGetItemDetailsGet($page_number, $page_size, $specified_date, $include_inactive);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV2ItemDetailsGetItemDetailsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **specified_date** | **\DateTime**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemDetails[]**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV2ItemDetailsItemMasterIdGet()`

```php
apiV2ItemDetailsItemMasterIdGet($item_master_id): \Opsuite2\Model\ItemDetails
```

Returns a single ItemDetails with the specified item master id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master_id = 56; // int

try {
    $result = $apiInstance->apiV2ItemDetailsItemMasterIdGet($item_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->apiV2ItemDetailsItemMasterIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemDetails**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getItemDetails()`

```php
getItemDetails($item_master_id): \Opsuite2\Model\ItemDetails
```

Returns a single ItemDetails with the specified item master id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_master_id = 56; // int

try {
    $result = $apiInstance->getItemDetails($item_master_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemDetailsApi->getItemDetails: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_master_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemDetails**](../Model/ItemDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
