# Opsuite2\ItemBinQuantitiesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemBinQuantitiesGetItemBinQuantitiesGet()**](ItemBinQuantitiesApi.md#apiV1ItemBinQuantitiesGetItemBinQuantitiesGet) | **GET** /api/v1/ItemBinQuantities/GetItemBinQuantities | Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren&#39;t set  then the last updated date and location id are required parameters |
| [**apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost()**](ItemBinQuantitiesApi.md#apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost) | **POST** /api/v1/ItemBinQuantities/UpdateItemBinQuantitiesById | Posts an array of ItemBinQuantitiesUpdates |
| [**apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost()**](ItemBinQuantitiesApi.md#apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost) | **POST** /api/v1/ItemBinQuantities/UpdateItemBinQuantities | Posts an array of ItemBinQuantitiesUpdates |


## `apiV1ItemBinQuantitiesGetItemBinQuantitiesGet()`

```php
apiV1ItemBinQuantitiesGetItemBinQuantitiesGet($page_number, $page_size, $location_id, $last_updated, $order_id, $order_number, $transfer_id, $transfer_number): \Opsuite2\Model\ItemBinQuantities[]
```

Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren't set  then the last updated date and location id are required parameters

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemBinQuantitiesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$last_updated = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$order_id = 56; // int
$order_number = 'order_number_example'; // string
$transfer_id = 56; // int
$transfer_number = 'transfer_number_example'; // string

try {
    $result = $apiInstance->apiV1ItemBinQuantitiesGetItemBinQuantitiesGet($page_number, $page_size, $location_id, $last_updated, $order_id, $order_number, $transfer_id, $transfer_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemBinQuantitiesApi->apiV1ItemBinQuantitiesGetItemBinQuantitiesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **last_updated** | **\DateTime**|  | [optional] |
| **order_id** | **int**|  | [optional] |
| **order_number** | **string**|  | [optional] |
| **transfer_id** | **int**|  | [optional] |
| **transfer_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemBinQuantities[]**](../Model/ItemBinQuantities.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost()`

```php
apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost($item_bin_quantities_update): \Opsuite2\Model\ItemBinQuantitiesUpdate[]
```

Posts an array of ItemBinQuantitiesUpdates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemBinQuantitiesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_bin_quantities_update = array(new \Opsuite2\Model\ItemBinQuantitiesUpdate()); // \Opsuite2\Model\ItemBinQuantitiesUpdate[]

try {
    $result = $apiInstance->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost($item_bin_quantities_update);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemBinQuantitiesApi->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_bin_quantities_update** | [**\Opsuite2\Model\ItemBinQuantitiesUpdate[]**](../Model/ItemBinQuantitiesUpdate.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemBinQuantitiesUpdate[]**](../Model/ItemBinQuantitiesUpdate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost()`

```php
apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost($item_bin_quantities_update_by_name): \Opsuite2\Model\ItemBinQuantitiesUpdate[]
```

Posts an array of ItemBinQuantitiesUpdates

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemBinQuantitiesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_bin_quantities_update_by_name = array(new \Opsuite2\Model\ItemBinQuantitiesUpdateByName()); // \Opsuite2\Model\ItemBinQuantitiesUpdateByName[]

try {
    $result = $apiInstance->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost($item_bin_quantities_update_by_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemBinQuantitiesApi->apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_bin_quantities_update_by_name** | [**\Opsuite2\Model\ItemBinQuantitiesUpdateByName[]**](../Model/ItemBinQuantitiesUpdateByName.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemBinQuantitiesUpdate[]**](../Model/ItemBinQuantitiesUpdate.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
