# Opsuite2\ItemAliasesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1ItemAliasesAliasIdDelete()**](ItemAliasesApi.md#apiV1ItemAliasesAliasIdDelete) | **DELETE** /api/v1/ItemAliases/{aliasId} | Deletes a single item alias by reference to id. |
| [**apiV1ItemAliasesGetItemAliasByAliasGet()**](ItemAliasesApi.md#apiV1ItemAliasesGetItemAliasByAliasGet) | **GET** /api/v1/ItemAliases/GetItemAliasByAlias | Returns a single ItemAlias with the specified alias. |
| [**apiV1ItemAliasesPatchMultipleItemAliasesPatch()**](ItemAliasesApi.md#apiV1ItemAliasesPatchMultipleItemAliasesPatch) | **PATCH** /api/v1/ItemAliases/PatchMultipleItemAliases | Updates specified properties of multiple item aliases. |
| [**apiV1ItemAliasesPostMultipleItemAliasesPost()**](ItemAliasesApi.md#apiV1ItemAliasesPostMultipleItemAliasesPost) | **POST** /api/v1/ItemAliases/PostMultipleItemAliases | Creates multiple new ItemAliases. |
| [**getItemAliasById()**](ItemAliasesApi.md#getItemAliasById) | **GET** /api/v1/ItemAliases/{aliasId} | Returns a single ItemAlias with the specified id. |


## `apiV1ItemAliasesAliasIdDelete()`

```php
apiV1ItemAliasesAliasIdDelete($alias_id)
```

Deletes a single item alias by reference to id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemAliasesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$alias_id = 56; // int

try {
    $apiInstance->apiV1ItemAliasesAliasIdDelete($alias_id);
} catch (Exception $e) {
    echo 'Exception when calling ItemAliasesApi->apiV1ItemAliasesAliasIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **alias_id** | **int**|  | |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemAliasesGetItemAliasByAliasGet()`

```php
apiV1ItemAliasesGetItemAliasByAliasGet($alias): \Opsuite2\Model\ItemAlias
```

Returns a single ItemAlias with the specified alias.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemAliasesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$alias = 'alias_example'; // string

try {
    $result = $apiInstance->apiV1ItemAliasesGetItemAliasByAliasGet($alias);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemAliasesApi->apiV1ItemAliasesGetItemAliasByAliasGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **alias** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\ItemAlias**](../Model/ItemAlias.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemAliasesPatchMultipleItemAliasesPatch()`

```php
apiV1ItemAliasesPatchMultipleItemAliasesPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple item aliases.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemAliasesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1ItemAliasesPatchMultipleItemAliasesPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemAliasesApi->apiV1ItemAliasesPatchMultipleItemAliasesPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1ItemAliasesPostMultipleItemAliasesPost()`

```php
apiV1ItemAliasesPostMultipleItemAliasesPost($item_alias): \Opsuite2\Model\PostResponseItemAlias[]
```

Creates multiple new ItemAliases.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemAliasesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$item_alias = array(new \Opsuite2\Model\ItemAlias()); // \Opsuite2\Model\ItemAlias[]

try {
    $result = $apiInstance->apiV1ItemAliasesPostMultipleItemAliasesPost($item_alias);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemAliasesApi->apiV1ItemAliasesPostMultipleItemAliasesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **item_alias** | [**\Opsuite2\Model\ItemAlias[]**](../Model/ItemAlias.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseItemAlias[]**](../Model/PostResponseItemAlias.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getItemAliasById()`

```php
getItemAliasById($alias_id): \Opsuite2\Model\ItemAlias
```

Returns a single ItemAlias with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\ItemAliasesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$alias_id = 56; // int

try {
    $result = $apiInstance->getItemAliasById($alias_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ItemAliasesApi->getItemAliasById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **alias_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\ItemAlias**](../Model/ItemAlias.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
