# Opsuite2\InvoiceMatchingApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1InvoiceMatchingGet()**](InvoiceMatchingApi.md#apiV1InvoiceMatchingGet) | **GET** /api/v1/InvoiceMatching | Returns an array of Invoices. |
| [**apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet()**](InvoiceMatchingApi.md#apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet) | **GET** /api/v1/InvoiceMatching/GetInvoiceMatchingItemDetailsById | Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size |
| [**apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet()**](InvoiceMatchingApi.md#apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet) | **GET** /api/v1/InvoiceMatching/GetInvoiceMatchingItemDetailsByNumber | Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size |


## `apiV1InvoiceMatchingGet()`

```php
apiV1InvoiceMatchingGet($page_number, $page_size, $invoice_creation_start_date, $invoice_creation_end_date, $invoice_type, $status, $invoice_number_start, $invoice_number_end): \Opsuite2\Model\InvoiceMatching[]
```

Returns an array of Invoices.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\InvoiceMatchingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$invoice_creation_start_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$invoice_creation_end_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$invoice_type = new \Opsuite2\Model\\Opsuite2\Model\InvoiceTypeEnum(); // \Opsuite2\Model\InvoiceTypeEnum
$status = 'status_example'; // string
$invoice_number_start = 'invoice_number_start_example'; // string
$invoice_number_end = 'invoice_number_end_example'; // string

try {
    $result = $apiInstance->apiV1InvoiceMatchingGet($page_number, $page_size, $invoice_creation_start_date, $invoice_creation_end_date, $invoice_type, $status, $invoice_number_start, $invoice_number_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoiceMatchingApi->apiV1InvoiceMatchingGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **invoice_creation_start_date** | **\DateTime**|  | [optional] |
| **invoice_creation_end_date** | **\DateTime**|  | [optional] |
| **invoice_type** | [**\Opsuite2\Model\InvoiceTypeEnum**](../Model/.md)|  | [optional] |
| **status** | **string**|  | [optional] |
| **invoice_number_start** | **string**|  | [optional] |
| **invoice_number_end** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\InvoiceMatching[]**](../Model/InvoiceMatching.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet()`

```php
apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet($page_number, $page_size, $invoice_document_id): \Opsuite2\Model\InvoiceMatchingLine[]
```

Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\InvoiceMatchingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$invoice_document_id = 56; // int

try {
    $result = $apiInstance->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet($page_number, $page_size, $invoice_document_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoiceMatchingApi->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **invoice_document_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\InvoiceMatchingLine[]**](../Model/InvoiceMatchingLine.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet()`

```php
apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet($page_number, $page_size, $invoice_number): \Opsuite2\Model\InvoiceMatchingLine[]
```

Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\InvoiceMatchingApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$invoice_number = 'invoice_number_example'; // string

try {
    $result = $apiInstance->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet($page_number, $page_size, $invoice_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoiceMatchingApi->apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **invoice_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\InvoiceMatchingLine[]**](../Model/InvoiceMatchingLine.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
