# Opsuite2\HospitalityTablesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1HospitalityTablesGet()**](HospitalityTablesApi.md#apiV1HospitalityTablesGet) | **GET** /api/v1/HospitalityTables | Returns an array of HospitalityTables that match the specified search criteria. |


## `apiV1HospitalityTablesGet()`

```php
apiV1HospitalityTablesGet($page_number, $page_size, $location_id, $room_name, $room_name_search_operator, $room_id): \Opsuite2\Model\HospitalityTable[]
```

Returns an array of HospitalityTables that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\HospitalityTablesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$room_name = 'room_name_example'; // string
$room_name_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$room_id = 56; // int

try {
    $result = $apiInstance->apiV1HospitalityTablesGet($page_number, $page_size, $location_id, $room_name, $room_name_search_operator, $room_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HospitalityTablesApi->apiV1HospitalityTablesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **room_name** | **string**|  | [optional] |
| **room_name_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **room_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\HospitalityTable[]**](../Model/HospitalityTable.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
