# Opsuite2\HospitalityRoomsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1HospitalityRoomsGet()**](HospitalityRoomsApi.md#apiV1HospitalityRoomsGet) | **GET** /api/v1/HospitalityRooms | Returns an array of HospitalityRooms that match the specified search criteria. |
| [**apiV1HospitalityRoomsGetHospitalityRoomByNameGet()**](HospitalityRoomsApi.md#apiV1HospitalityRoomsGetHospitalityRoomByNameGet) | **GET** /api/v1/HospitalityRooms/GetHospitalityRoomByName | Returns a single HospitalityRoom with the specified name. |
| [**getHospitalityRoomById()**](HospitalityRoomsApi.md#getHospitalityRoomById) | **GET** /api/v1/HospitalityRooms/{roomId} | Returns a single HospitalityRoom with the specified id. |


## `apiV1HospitalityRoomsGet()`

```php
apiV1HospitalityRoomsGet($page_number, $page_size, $location_id, $location_code, $location_name, $location_name_search_operator, $include_tables): \Opsuite2\Model\HospitalityRoom[]
```

Returns an array of HospitalityRooms that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\HospitalityRoomsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$location_id = 56; // int
$location_code = 'location_code_example'; // string
$location_name = 'location_name_example'; // string
$location_name_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$include_tables = True; // bool

try {
    $result = $apiInstance->apiV1HospitalityRoomsGet($page_number, $page_size, $location_id, $location_code, $location_name, $location_name_search_operator, $include_tables);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HospitalityRoomsApi->apiV1HospitalityRoomsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **location_code** | **string**|  | [optional] |
| **location_name** | **string**|  | [optional] |
| **location_name_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **include_tables** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\HospitalityRoom[]**](../Model/HospitalityRoom.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1HospitalityRoomsGetHospitalityRoomByNameGet()`

```php
apiV1HospitalityRoomsGetHospitalityRoomByNameGet($room_name): \Opsuite2\Model\HospitalityRoom
```

Returns a single HospitalityRoom with the specified name.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\HospitalityRoomsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$room_name = 'room_name_example'; // string

try {
    $result = $apiInstance->apiV1HospitalityRoomsGetHospitalityRoomByNameGet($room_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HospitalityRoomsApi->apiV1HospitalityRoomsGetHospitalityRoomByNameGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **room_name** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\HospitalityRoom**](../Model/HospitalityRoom.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getHospitalityRoomById()`

```php
getHospitalityRoomById($room_id): \Opsuite2\Model\HospitalityRoom
```

Returns a single HospitalityRoom with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\HospitalityRoomsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$room_id = 56; // int

try {
    $result = $apiInstance->getHospitalityRoomById($room_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling HospitalityRoomsApi->getHospitalityRoomById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **room_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\HospitalityRoom**](../Model/HospitalityRoom.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
