# Opsuite2\GRNDetailsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1GRNDetailsGetGRNDetailsByOrderNumberGet()**](GRNDetailsApi.md#apiV1GRNDetailsGetGRNDetailsByOrderNumberGet) | **GET** /api/v1/GRNDetails/GetGRNDetailsByOrderNumber | Returns a GRNDetails for a given inventory control document order number. |
| [**apiV1GRNDetailsGetGRNDetailsGet()**](GRNDetailsApi.md#apiV1GRNDetailsGetGRNDetailsGet) | **GET** /api/v1/GRNDetails/GetGRNDetails | Returns an array of GRNDetails that match the specified search criteria. |
| [**apiV1GRNDetailsGetGRNLinesByGRNNumberGet()**](GRNDetailsApi.md#apiV1GRNDetailsGetGRNLinesByGRNNumberGet) | **GET** /api/v1/GRNDetails/GetGRNLinesByGRNNumber | Returns the lines on a GRN. |
| [**apiV1GRNDetailsGetGRNLinesByIdGet()**](GRNDetailsApi.md#apiV1GRNDetailsGetGRNLinesByIdGet) | **GET** /api/v1/GRNDetails/GetGRNLinesById | Returns the lines on a GRN. |
| [**getGRNDetailsById()**](GRNDetailsApi.md#getGRNDetailsById) | **GET** /api/v1/GRNDetails/{receivingDocumentId} | Returns a GRNDetails for a given receiving document id. |


## `apiV1GRNDetailsGetGRNDetailsByOrderNumberGet()`

```php
apiV1GRNDetailsGetGRNDetailsByOrderNumberGet($order_number): \Opsuite2\Model\GRNDetails
```

Returns a GRNDetails for a given inventory control document order number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\GRNDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_number = 'order_number_example'; // string

try {
    $result = $apiInstance->apiV1GRNDetailsGetGRNDetailsByOrderNumberGet($order_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GRNDetailsApi->apiV1GRNDetailsGetGRNDetailsByOrderNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **order_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\GRNDetails**](../Model/GRNDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1GRNDetailsGetGRNDetailsGet()`

```php
apiV1GRNDetailsGetGRNDetailsGet($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_committed_date_range_start, $date_committed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $location_id, $source_location_id, $destination_location_id, $receiving_document_type, $order_number, $order_number_search_operator): \Opsuite2\Model\GRNDetails[]
```

Returns an array of GRNDetails that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\GRNDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$date_created_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_created_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_committed_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_committed_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$location_id = 56; // int
$source_location_id = 56; // int
$destination_location_id = 56; // int
$receiving_document_type = new \Opsuite2\Model\\Opsuite2\Model\ReceivingDocumentTypeEnum(); // \Opsuite2\Model\ReceivingDocumentTypeEnum
$order_number = 'order_number_example'; // string
$order_number_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum

try {
    $result = $apiInstance->apiV1GRNDetailsGetGRNDetailsGet($page_number, $page_size, $date_created_date_range_start, $date_created_date_range_end, $date_committed_date_range_start, $date_committed_date_range_end, $last_updated_date_range_start, $last_updated_date_range_end, $location_id, $source_location_id, $destination_location_id, $receiving_document_type, $order_number, $order_number_search_operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GRNDetailsApi->apiV1GRNDetailsGetGRNDetailsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **date_created_date_range_start** | **\DateTime**|  | [optional] |
| **date_created_date_range_end** | **\DateTime**|  | [optional] |
| **date_committed_date_range_start** | **\DateTime**|  | [optional] |
| **date_committed_date_range_end** | **\DateTime**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |
| **location_id** | **int**|  | [optional] |
| **source_location_id** | **int**|  | [optional] |
| **destination_location_id** | **int**|  | [optional] |
| **receiving_document_type** | [**\Opsuite2\Model\ReceivingDocumentTypeEnum**](../Model/.md)|  | [optional] |
| **order_number** | **string**|  | [optional] |
| **order_number_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\GRNDetails[]**](../Model/GRNDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1GRNDetailsGetGRNLinesByGRNNumberGet()`

```php
apiV1GRNDetailsGetGRNLinesByGRNNumberGet($page_number, $page_size, $grn_number)
```

Returns the lines on a GRN.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\GRNDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$grn_number = 'grn_number_example'; // string

try {
    $apiInstance->apiV1GRNDetailsGetGRNLinesByGRNNumberGet($page_number, $page_size, $grn_number);
} catch (Exception $e) {
    echo 'Exception when calling GRNDetailsApi->apiV1GRNDetailsGetGRNLinesByGRNNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **grn_number** | **string**|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1GRNDetailsGetGRNLinesByIdGet()`

```php
apiV1GRNDetailsGetGRNLinesByIdGet($page_number, $page_size, $inventory_control_document_id)
```

Returns the lines on a GRN.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\GRNDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$inventory_control_document_id = 56; // int

try {
    $apiInstance->apiV1GRNDetailsGetGRNLinesByIdGet($page_number, $page_size, $inventory_control_document_id);
} catch (Exception $e) {
    echo 'Exception when calling GRNDetailsApi->apiV1GRNDetailsGetGRNLinesByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **inventory_control_document_id** | **int**|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getGRNDetailsById()`

```php
getGRNDetailsById($receiving_document_id): \Opsuite2\Model\GRNDetails
```

Returns a GRNDetails for a given receiving document id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\GRNDetailsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$receiving_document_id = 56; // int

try {
    $result = $apiInstance->getGRNDetailsById($receiving_document_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GRNDetailsApi->getGRNDetailsById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **receiving_document_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\GRNDetails**](../Model/GRNDetails.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
