# Opsuite2\DepartmentsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1DepartmentsDepartmentIdPatch()**](DepartmentsApi.md#apiV1DepartmentsDepartmentIdPatch) | **PATCH** /api/v1/Departments/{departmentId} | Updates specified properties of a department. |
| [**apiV1DepartmentsGet()**](DepartmentsApi.md#apiV1DepartmentsGet) | **GET** /api/v1/Departments | Returns an array of Departments that match the specified search criteria. |
| [**apiV1DepartmentsGetDepartmentByCodeGet()**](DepartmentsApi.md#apiV1DepartmentsGetDepartmentByCodeGet) | **GET** /api/v1/Departments/GetDepartmentByCode | Returns a single Department with the specified code. |
| [**apiV1DepartmentsPatchMultipleDepartmentsPatch()**](DepartmentsApi.md#apiV1DepartmentsPatchMultipleDepartmentsPatch) | **PATCH** /api/v1/Departments/PatchMultipleDepartments | Updates specified properties of multiple departments. |
| [**apiV1DepartmentsPost()**](DepartmentsApi.md#apiV1DepartmentsPost) | **POST** /api/v1/Departments | Creates a new department. |
| [**apiV1DepartmentsPostMultipleDepartmentsPost()**](DepartmentsApi.md#apiV1DepartmentsPostMultipleDepartmentsPost) | **POST** /api/v1/Departments/PostMultipleDepartments | Creates multiple new departments. |
| [**getDepartmentById()**](DepartmentsApi.md#getDepartmentById) | **GET** /api/v1/Departments/{departmentId} | Returns a single Department with the specified id. |


## `apiV1DepartmentsDepartmentIdPatch()`

```php
apiV1DepartmentsDepartmentIdPatch($department_id, $patch)
```

Updates specified properties of a department.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$department_id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1DepartmentsDepartmentIdPatch($department_id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->apiV1DepartmentsDepartmentIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **department_id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1DepartmentsGet()`

```php
apiV1DepartmentsGet($page_number, $page_size): \Opsuite2\Model\Department[]
```

Returns an array of Departments that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1DepartmentsGet($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->apiV1DepartmentsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\Department[]**](../Model/Department.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1DepartmentsGetDepartmentByCodeGet()`

```php
apiV1DepartmentsGetDepartmentByCodeGet($department_code): \Opsuite2\Model\Department
```

Returns a single Department with the specified code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$department_code = 'department_code_example'; // string

try {
    $result = $apiInstance->apiV1DepartmentsGetDepartmentByCodeGet($department_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->apiV1DepartmentsGetDepartmentByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **department_code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Department**](../Model/Department.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1DepartmentsPatchMultipleDepartmentsPatch()`

```php
apiV1DepartmentsPatchMultipleDepartmentsPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple departments.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1DepartmentsPatchMultipleDepartmentsPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->apiV1DepartmentsPatchMultipleDepartmentsPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1DepartmentsPost()`

```php
apiV1DepartmentsPost($department): \Opsuite2\Model\Department
```

Creates a new department.

Returns the newly created department.  Returns a 422 response code if a department already exists with the same department code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$department = new \Opsuite2\Model\Department(); // \Opsuite2\Model\Department

try {
    $result = $apiInstance->apiV1DepartmentsPost($department);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->apiV1DepartmentsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **department** | [**\Opsuite2\Model\Department**](../Model/Department.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Department**](../Model/Department.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1DepartmentsPostMultipleDepartmentsPost()`

```php
apiV1DepartmentsPostMultipleDepartmentsPost($department): \Opsuite2\Model\PostResponseDepartment[]
```

Creates multiple new departments.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$department = array(new \Opsuite2\Model\Department()); // \Opsuite2\Model\Department[]

try {
    $result = $apiInstance->apiV1DepartmentsPostMultipleDepartmentsPost($department);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->apiV1DepartmentsPostMultipleDepartmentsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **department** | [**\Opsuite2\Model\Department[]**](../Model/Department.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseDepartment[]**](../Model/PostResponseDepartment.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getDepartmentById()`

```php
getDepartmentById($department_id): \Opsuite2\Model\Department
```

Returns a single Department with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\DepartmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$department_id = 56; // int

try {
    $result = $apiInstance->getDepartmentById($department_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DepartmentsApi->getDepartmentById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **department_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Department**](../Model/Department.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
