# Opsuite2\CustomersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CustomersCustomerIdAllContactsGet()**](CustomersApi.md#apiV1CustomersCustomerIdAllContactsGet) | **GET** /api/v1/Customers/{customerId}/AllContacts | Returns an array of all contacts for the specified customer. |
| [**apiV1CustomersCustomerIdAlternativeShipToContactsGet()**](CustomersApi.md#apiV1CustomersCustomerIdAlternativeShipToContactsGet) | **GET** /api/v1/Customers/{customerId}/AlternativeShipToContacts | Returns an array of alternative ship to contacts for the specified customer. |
| [**apiV1CustomersCustomerIdContactsGet()**](CustomersApi.md#apiV1CustomersCustomerIdContactsGet) | **GET** /api/v1/Customers/{customerId}/Contacts | Returns an array of other contacts for the specified customer. |
| [**apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet()**](CustomersApi.md#apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet) | **GET** /api/v1/Customers/{customerId}/CustomerLoyaltyFields | Returns the customer loyalty fields for the specified customer. |
| [**apiV1CustomersCustomerIdDiscountCouponsGet()**](CustomersApi.md#apiV1CustomersCustomerIdDiscountCouponsGet) | **GET** /api/v1/Customers/{customerId}/DiscountCoupons | Returns an array of discount coupons for the specified customer. |
| [**apiV1CustomersCustomerIdLoyaltyBalancesGet()**](CustomersApi.md#apiV1CustomersCustomerIdLoyaltyBalancesGet) | **GET** /api/v1/Customers/{customerId}/LoyaltyBalances | Returns an array of loyalty point balances for the specified customer. |
| [**apiV1CustomersCustomerIdLoyaltyCardsGet()**](CustomersApi.md#apiV1CustomersCustomerIdLoyaltyCardsGet) | **GET** /api/v1/Customers/{customerId}/LoyaltyCards | Returns an array of loyalty cards for the specified customer. |
| [**apiV1CustomersCustomerIdLoyaltyTransactionsGet()**](CustomersApi.md#apiV1CustomersCustomerIdLoyaltyTransactionsGet) | **GET** /api/v1/Customers/{customerId}/LoyaltyTransactions | Returns an array of loyalty transactions for the specified customer. |
| [**apiV1CustomersCustomerIdPatch()**](CustomersApi.md#apiV1CustomersCustomerIdPatch) | **PATCH** /api/v1/Customers/{customerId} | Updates specified properties of a customer. |
| [**apiV1CustomersCustomerIdPromotionCouponsGet()**](CustomersApi.md#apiV1CustomersCustomerIdPromotionCouponsGet) | **GET** /api/v1/Customers/{customerId}/PromotionCoupons | Returns an array of promotion coupons for the specified customer. |
| [**apiV1CustomersCustomerIdTransactionHeadersGet()**](CustomersApi.md#apiV1CustomersCustomerIdTransactionHeadersGet) | **GET** /api/v1/Customers/{customerId}/TransactionHeaders | Returns an array of transaction headers for the specified customer. |
| [**apiV1CustomersExpiringLoyaltyTransactionsGet()**](CustomersApi.md#apiV1CustomersExpiringLoyaltyTransactionsGet) | **GET** /api/v1/Customers/ExpiringLoyaltyTransactions | Returns an array of expiring loyalty transactions for the specified customers. |
| [**apiV1CustomersExpiryingLoyaltyTransactionsGet()**](CustomersApi.md#apiV1CustomersExpiryingLoyaltyTransactionsGet) | **GET** /api/v1/Customers/ExpiryingLoyaltyTransactions | Returns an array of expiring loyalty transactions for the specified customers. |
| [**apiV1CustomersGet()**](CustomersApi.md#apiV1CustomersGet) | **GET** /api/v1/Customers | Returns an array of Customers that match the specified search criteria. |
| [**apiV1CustomersGetCustomerByAccountNumberGet()**](CustomersApi.md#apiV1CustomersGetCustomerByAccountNumberGet) | **GET** /api/v1/Customers/GetCustomerByAccountNumber | Returns a single Customer with the specified account number or loyalty card number. |
| [**apiV1CustomersGetCustomerByAddressGet()**](CustomersApi.md#apiV1CustomersGetCustomerByAddressGet) | **GET** /api/v1/Customers/GetCustomerByAddress | Returns a single Customer with the specified physical address. |
| [**apiV1CustomersGetCustomerByEmailAddressGet()**](CustomersApi.md#apiV1CustomersGetCustomerByEmailAddressGet) | **GET** /api/v1/Customers/GetCustomerByEmailAddress | Returns a single Customer with the specified email address. |
| [**apiV1CustomersPost()**](CustomersApi.md#apiV1CustomersPost) | **POST** /api/v1/Customers | Creates a new customer. |
| [**apiV1CustomersPut()**](CustomersApi.md#apiV1CustomersPut) | **PUT** /api/v1/Customers | Updates a batch of customers. |
| [**getCustomerById()**](CustomersApi.md#getCustomerById) | **GET** /api/v1/Customers/{customerId} | Returns a single Customer with the specified id. |


## `apiV1CustomersCustomerIdAllContactsGet()`

```php
apiV1CustomersCustomerIdAllContactsGet($customer_id, $page_number, $page_size): \Opsuite2\Model\CustomerContact[]
```

Returns an array of all contacts for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CustomersCustomerIdAllContactsGet($customer_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdAllContactsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerContact[]**](../Model/CustomerContact.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdAlternativeShipToContactsGet()`

```php
apiV1CustomersCustomerIdAlternativeShipToContactsGet($customer_id, $page_number, $page_size): \Opsuite2\Model\CustomerContact[]
```

Returns an array of alternative ship to contacts for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CustomersCustomerIdAlternativeShipToContactsGet($customer_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdAlternativeShipToContactsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerContact[]**](../Model/CustomerContact.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdContactsGet()`

```php
apiV1CustomersCustomerIdContactsGet($customer_id, $page_number, $page_size): \Opsuite2\Model\CustomerContact[]
```

Returns an array of other contacts for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CustomersCustomerIdContactsGet($customer_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdContactsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerContact[]**](../Model/CustomerContact.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet()`

```php
apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet($customer_id, $loyalty_card_number): \Opsuite2\Model\CustomerLoyaltyField
```

Returns the customer loyalty fields for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$loyalty_card_number = 'loyalty_card_number_example'; // string

try {
    $result = $apiInstance->apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet($customer_id, $loyalty_card_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **loyalty_card_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerLoyaltyField**](../Model/CustomerLoyaltyField.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdDiscountCouponsGet()`

```php
apiV1CustomersCustomerIdDiscountCouponsGet($customer_id, $page_number, $page_size, $include_zero_valued_coupons, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed): \Opsuite2\Model\CustomerDiscountCoupon[]
```

Returns an array of discount coupons for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int
$include_zero_valued_coupons = True; // bool
$include_expired = True; // bool
$expired_limit = 56; // int
$include_not_yet_valid = True; // bool
$valid_limit = 56; // int
$include_redeemed = True; // bool

try {
    $result = $apiInstance->apiV1CustomersCustomerIdDiscountCouponsGet($customer_id, $page_number, $page_size, $include_zero_valued_coupons, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdDiscountCouponsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_zero_valued_coupons** | **bool**|  | [optional] |
| **include_expired** | **bool**|  | [optional] |
| **expired_limit** | **int**|  | [optional] |
| **include_not_yet_valid** | **bool**|  | [optional] |
| **valid_limit** | **int**|  | [optional] |
| **include_redeemed** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerDiscountCoupon[]**](../Model/CustomerDiscountCoupon.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdLoyaltyBalancesGet()`

```php
apiV1CustomersCustomerIdLoyaltyBalancesGet($customer_id, $loyalty_type_id): \Opsuite2\Model\LoyaltyBalance[]
```

Returns an array of loyalty point balances for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$loyalty_type_id = 56; // int

try {
    $result = $apiInstance->apiV1CustomersCustomerIdLoyaltyBalancesGet($customer_id, $loyalty_type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdLoyaltyBalancesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **loyalty_type_id** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\LoyaltyBalance[]**](../Model/LoyaltyBalance.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdLoyaltyCardsGet()`

```php
apiV1CustomersCustomerIdLoyaltyCardsGet($customer_id): \Opsuite2\Model\LoyaltyCard[]
```

Returns an array of loyalty cards for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int

try {
    $result = $apiInstance->apiV1CustomersCustomerIdLoyaltyCardsGet($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdLoyaltyCardsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\LoyaltyCard[]**](../Model/LoyaltyCard.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdLoyaltyTransactionsGet()`

```php
apiV1CustomersCustomerIdLoyaltyTransactionsGet($customer_id, $page_number, $page_size, $date_range_start, $date_range_end): \Opsuite2\Model\LoyaltyTransaction[]
```

Returns an array of loyalty transactions for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1CustomersCustomerIdLoyaltyTransactionsGet($customer_id, $page_number, $page_size, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdLoyaltyTransactionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\LoyaltyTransaction[]**](../Model/LoyaltyTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdPatch()`

```php
apiV1CustomersCustomerIdPatch($customer_id, $patch)
```

Updates specified properties of a customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1CustomersCustomerIdPatch($customer_id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdPromotionCouponsGet()`

```php
apiV1CustomersCustomerIdPromotionCouponsGet($customer_id, $page_number, $page_size, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed): \Opsuite2\Model\CustomerPromotionCoupon[]
```

Returns an array of promotion coupons for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int
$include_expired = True; // bool
$expired_limit = 56; // int
$include_not_yet_valid = True; // bool
$valid_limit = 56; // int
$include_redeemed = True; // bool

try {
    $result = $apiInstance->apiV1CustomersCustomerIdPromotionCouponsGet($customer_id, $page_number, $page_size, $include_expired, $expired_limit, $include_not_yet_valid, $valid_limit, $include_redeemed);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdPromotionCouponsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_expired** | **bool**|  | [optional] |
| **expired_limit** | **int**|  | [optional] |
| **include_not_yet_valid** | **bool**|  | [optional] |
| **valid_limit** | **int**|  | [optional] |
| **include_redeemed** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerPromotionCoupon[]**](../Model/CustomerPromotionCoupon.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersCustomerIdTransactionHeadersGet()`

```php
apiV1CustomersCustomerIdTransactionHeadersGet($customer_id, $page_number, $page_size, $date_range_start, $date_range_end): \Opsuite2\Model\TransactionHeader[]
```

Returns an array of transaction headers for the specified customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1CustomersCustomerIdTransactionHeadersGet($customer_id, $page_number, $page_size, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersCustomerIdTransactionHeadersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\TransactionHeader[]**](../Model/TransactionHeader.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersExpiringLoyaltyTransactionsGet()`

```php
apiV1CustomersExpiringLoyaltyTransactionsGet($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end): \Opsuite2\Model\LoyaltyTransaction[]
```

Returns an array of expiring loyalty transactions for the specified customers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$customer_id = 56; // int
$customer_ids = array(56); // int[]
$loyalty_type_id = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1CustomersExpiringLoyaltyTransactionsGet($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersExpiringLoyaltyTransactionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **customer_id** | **int**|  | [optional] |
| **customer_ids** | [**int[]**](../Model/int.md)|  | [optional] |
| **loyalty_type_id** | **int**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\LoyaltyTransaction[]**](../Model/LoyaltyTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersExpiryingLoyaltyTransactionsGet()`

```php
apiV1CustomersExpiryingLoyaltyTransactionsGet($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end): \Opsuite2\Model\LoyaltyTransaction[]
```

Returns an array of expiring loyalty transactions for the specified customers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$customer_id = 56; // int
$customer_ids = array(56); // int[]
$loyalty_type_id = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1CustomersExpiryingLoyaltyTransactionsGet($page_number, $page_size, $customer_id, $customer_ids, $loyalty_type_id, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersExpiryingLoyaltyTransactionsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **customer_id** | **int**|  | [optional] |
| **customer_ids** | [**int[]**](../Model/int.md)|  | [optional] |
| **loyalty_type_id** | **int**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\LoyaltyTransaction[]**](../Model/LoyaltyTransaction.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersGet()`

```php
apiV1CustomersGet($page_number, $page_size, $account_number, $account_number_search_operator, $account_type_id, $loyalty_card_number, $loyalty_card_number_search_operator, $billing_first_name, $billing_last_name, $has_billing_email, $billing_email, $billing_email_search_operator, $ship_to_first_name, $ship_to_last_name, $has_ship_to_email, $ship_to_email, $ship_to_email_search_operator, $include_inactive, $last_updated_date_range_start, $last_updated_date_range_end, $account_opened_date_range_start, $account_opened_date_range_end, $last_visit_date_range_start, $last_visit_date_range_end, $opt_in_email, $opt_in_direct_mail, $opt_in_telephone, $loyalty_field_search_field_name, $loyalty_field_search_operator, $loyalty_field_search_search_value, $birthday_month, $is_referred, $customer_ids): \Opsuite2\Model\Customer[]
```

Returns an array of Customers that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$account_number = 'account_number_example'; // string
$account_number_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$account_type_id = 56; // int
$loyalty_card_number = 'loyalty_card_number_example'; // string
$loyalty_card_number_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$billing_first_name = 'billing_first_name_example'; // string
$billing_last_name = 'billing_last_name_example'; // string
$has_billing_email = True; // bool
$billing_email = 'billing_email_example'; // string
$billing_email_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$ship_to_first_name = 'ship_to_first_name_example'; // string
$ship_to_last_name = 'ship_to_last_name_example'; // string
$has_ship_to_email = True; // bool
$ship_to_email = 'ship_to_email_example'; // string
$ship_to_email_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$include_inactive = True; // bool
$last_updated_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_updated_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$account_opened_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$account_opened_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_visit_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$last_visit_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$opt_in_email = True; // bool
$opt_in_direct_mail = True; // bool
$opt_in_telephone = True; // bool
$loyalty_field_search_field_name = 'loyalty_field_search_field_name_example'; // string
$loyalty_field_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SearchOperatorEnum(); // \Opsuite2\Model\SearchOperatorEnum
$loyalty_field_search_search_value = 'loyalty_field_search_search_value_example'; // string
$birthday_month = 56; // int
$is_referred = True; // bool
$customer_ids = array(56); // int[]

try {
    $result = $apiInstance->apiV1CustomersGet($page_number, $page_size, $account_number, $account_number_search_operator, $account_type_id, $loyalty_card_number, $loyalty_card_number_search_operator, $billing_first_name, $billing_last_name, $has_billing_email, $billing_email, $billing_email_search_operator, $ship_to_first_name, $ship_to_last_name, $has_ship_to_email, $ship_to_email, $ship_to_email_search_operator, $include_inactive, $last_updated_date_range_start, $last_updated_date_range_end, $account_opened_date_range_start, $account_opened_date_range_end, $last_visit_date_range_start, $last_visit_date_range_end, $opt_in_email, $opt_in_direct_mail, $opt_in_telephone, $loyalty_field_search_field_name, $loyalty_field_search_operator, $loyalty_field_search_search_value, $birthday_month, $is_referred, $customer_ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **account_number** | **string**|  | [optional] |
| **account_number_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **account_type_id** | **int**|  | [optional] |
| **loyalty_card_number** | **string**|  | [optional] |
| **loyalty_card_number_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **billing_first_name** | **string**|  | [optional] |
| **billing_last_name** | **string**|  | [optional] |
| **has_billing_email** | **bool**|  | [optional] |
| **billing_email** | **string**|  | [optional] |
| **billing_email_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **ship_to_first_name** | **string**|  | [optional] |
| **ship_to_last_name** | **string**|  | [optional] |
| **has_ship_to_email** | **bool**|  | [optional] |
| **ship_to_email** | **string**|  | [optional] |
| **ship_to_email_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |
| **last_updated_date_range_start** | **\DateTime**|  | [optional] |
| **last_updated_date_range_end** | **\DateTime**|  | [optional] |
| **account_opened_date_range_start** | **\DateTime**|  | [optional] |
| **account_opened_date_range_end** | **\DateTime**|  | [optional] |
| **last_visit_date_range_start** | **\DateTime**|  | [optional] |
| **last_visit_date_range_end** | **\DateTime**|  | [optional] |
| **opt_in_email** | **bool**|  | [optional] |
| **opt_in_direct_mail** | **bool**|  | [optional] |
| **opt_in_telephone** | **bool**|  | [optional] |
| **loyalty_field_search_field_name** | **string**|  | [optional] |
| **loyalty_field_search_operator** | [**\Opsuite2\Model\SearchOperatorEnum**](../Model/.md)|  | [optional] |
| **loyalty_field_search_search_value** | **string**|  | [optional] |
| **birthday_month** | **int**|  | [optional] |
| **is_referred** | **bool**|  | [optional] |
| **customer_ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Customer[]**](../Model/Customer.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersGetCustomerByAccountNumberGet()`

```php
apiV1CustomersGetCustomerByAccountNumberGet($account_number): \Opsuite2\Model\Customer
```

Returns a single Customer with the specified account number or loyalty card number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$account_number = 'account_number_example'; // string

try {
    $result = $apiInstance->apiV1CustomersGetCustomerByAccountNumberGet($account_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersGetCustomerByAccountNumberGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **account_number** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Customer**](../Model/Customer.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersGetCustomerByAddressGet()`

```php
apiV1CustomersGetCustomerByAddressGet($address_line1, $postcode): \Opsuite2\Model\Customer
```

Returns a single Customer with the specified physical address.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$address_line1 = 'address_line1_example'; // string
$postcode = 'postcode_example'; // string

try {
    $result = $apiInstance->apiV1CustomersGetCustomerByAddressGet($address_line1, $postcode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersGetCustomerByAddressGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **address_line1** | **string**|  | [optional] |
| **postcode** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Customer**](../Model/Customer.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersGetCustomerByEmailAddressGet()`

```php
apiV1CustomersGetCustomerByEmailAddressGet($email_address): \Opsuite2\Model\Customer
```

Returns a single Customer with the specified email address.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$email_address = 'email_address_example'; // string

try {
    $result = $apiInstance->apiV1CustomersGetCustomerByEmailAddressGet($email_address);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersGetCustomerByEmailAddressGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **email_address** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Customer**](../Model/Customer.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersPost()`

```php
apiV1CustomersPost($customer): \Opsuite2\Model\Customer
```

Creates a new customer.

Returns a 422 response code if a customer already exists with the same account number.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer = new \Opsuite2\Model\Customer(); // \Opsuite2\Model\Customer

try {
    $result = $apiInstance->apiV1CustomersPost($customer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer** | [**\Opsuite2\Model\Customer**](../Model/Customer.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Customer**](../Model/Customer.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomersPut()`

```php
apiV1CustomersPut($customer)
```

Updates a batch of customers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer = array(new \Opsuite2\Model\Customer()); // \Opsuite2\Model\Customer[]

try {
    $apiInstance->apiV1CustomersPut($customer);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->apiV1CustomersPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer** | [**\Opsuite2\Model\Customer[]**](../Model/Customer.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerById()`

```php
getCustomerById($customer_id): \Opsuite2\Model\Customer
```

Returns a single Customer with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int

try {
    $result = $apiInstance->getCustomerById($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomerById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Customer**](../Model/Customer.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
