# Opsuite2\CustomerRewardsCampaignsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet()**](CustomerRewardsCampaignsApi.md#apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet) | **GET** /api/v1/CustomerRewardsCampaigns/{campaignId}/DiscountCoupons | Returns an array of discount coupons for the specified customer rewards campaign |
| [**apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet()**](CustomerRewardsCampaignsApi.md#apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet) | **GET** /api/v1/CustomerRewardsCampaigns/{campaignId}/PromotionCoupons | Returns an array of promotion coupons for the specified customer rewards campaign |
| [**apiV1CustomerRewardsCampaignsGet()**](CustomerRewardsCampaignsApi.md#apiV1CustomerRewardsCampaignsGet) | **GET** /api/v1/CustomerRewardsCampaigns | Returns an array of Customer Rewards Campaigns. |
| [**apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet()**](CustomerRewardsCampaignsApi.md#apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet) | **GET** /api/v1/CustomerRewardsCampaigns/GetCustomerRewardsCampaignByCode | Returns a single Customer Rewards Campaign with the specified code. |
| [**getCustomerRewardsCampaignById()**](CustomerRewardsCampaignsApi.md#getCustomerRewardsCampaignById) | **GET** /api/v1/CustomerRewardsCampaigns/{campaignId} | Returns a single Customer Rewards Campaign with the specified id. |


## `apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet()`

```php
apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet($campaign_id, $include_zero_valued_coupons, $page_number, $page_size): \Opsuite2\Model\CustomerDiscountCoupon[]
```

Returns an array of discount coupons for the specified customer rewards campaign

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerRewardsCampaignsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$campaign_id = 56; // int
$include_zero_valued_coupons = True; // bool
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet($campaign_id, $include_zero_valued_coupons, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerRewardsCampaignsApi->apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **campaign_id** | **int**|  | |
| **include_zero_valued_coupons** | **bool**|  | [optional] |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerDiscountCoupon[]**](../Model/CustomerDiscountCoupon.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet()`

```php
apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet($campaign_id, $page_number, $page_size): \Opsuite2\Model\CustomerPromotionCoupon[]
```

Returns an array of promotion coupons for the specified customer rewards campaign

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerRewardsCampaignsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$campaign_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet($campaign_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerRewardsCampaignsApi->apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **campaign_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerPromotionCoupon[]**](../Model/CustomerPromotionCoupon.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerRewardsCampaignsGet()`

```php
apiV1CustomerRewardsCampaignsGet($page_number, $page_size): \Opsuite2\Model\CustomerRewardsCampaign[]
```

Returns an array of Customer Rewards Campaigns.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerRewardsCampaignsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CustomerRewardsCampaignsGet($page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerRewardsCampaignsApi->apiV1CustomerRewardsCampaignsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerRewardsCampaign[]**](../Model/CustomerRewardsCampaign.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet()`

```php
apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet($campaign_code): \Opsuite2\Model\CustomerRewardsCampaign
```

Returns a single Customer Rewards Campaign with the specified code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerRewardsCampaignsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$campaign_code = 'campaign_code_example'; // string

try {
    $result = $apiInstance->apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet($campaign_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerRewardsCampaignsApi->apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **campaign_code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerRewardsCampaign**](../Model/CustomerRewardsCampaign.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerRewardsCampaignById()`

```php
getCustomerRewardsCampaignById($campaign_id): \Opsuite2\Model\CustomerRewardsCampaign
```

Returns a single Customer Rewards Campaign with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerRewardsCampaignsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$campaign_id = 56; // int

try {
    $result = $apiInstance->getCustomerRewardsCampaignById($campaign_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerRewardsCampaignsApi->getCustomerRewardsCampaignById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **campaign_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\CustomerRewardsCampaign**](../Model/CustomerRewardsCampaign.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
