# Opsuite2\CustomerLoyaltyFieldsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CustomerLoyaltyFieldsGet()**](CustomerLoyaltyFieldsApi.md#apiV1CustomerLoyaltyFieldsGet) | **GET** /api/v1/CustomerLoyaltyFields | Returns an array of customer loyalty fields. |
| [**apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet()**](CustomerLoyaltyFieldsApi.md#apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet) | **GET** /api/v1/CustomerLoyaltyFields/GetCustomerLoyaltyFieldsByLoyaltyCards | Returns an array of customer loyalty fields. |
| [**apiV1CustomerLoyaltyFieldsPut()**](CustomerLoyaltyFieldsApi.md#apiV1CustomerLoyaltyFieldsPut) | **PUT** /api/v1/CustomerLoyaltyFields | Updates a batch of customer loyalty field. |


## `apiV1CustomerLoyaltyFieldsGet()`

```php
apiV1CustomerLoyaltyFieldsGet($page_number, $page_size, $customer_ids): \Opsuite2\Model\CustomerLoyaltyField[]
```

Returns an array of customer loyalty fields.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerLoyaltyFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$customer_ids = array(56); // int[]

try {
    $result = $apiInstance->apiV1CustomerLoyaltyFieldsGet($page_number, $page_size, $customer_ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerLoyaltyFieldsApi->apiV1CustomerLoyaltyFieldsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **customer_ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerLoyaltyField[]**](../Model/CustomerLoyaltyField.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet()`

```php
apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet($page_number, $page_size, $loyalty_card_ids): \Opsuite2\Model\CustomerLoyaltyField[]
```

Returns an array of customer loyalty fields.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerLoyaltyFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$loyalty_card_ids = array(56); // int[]

try {
    $result = $apiInstance->apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet($page_number, $page_size, $loyalty_card_ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerLoyaltyFieldsApi->apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **loyalty_card_ids** | [**int[]**](../Model/int.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerLoyaltyField[]**](../Model/CustomerLoyaltyField.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerLoyaltyFieldsPut()`

```php
apiV1CustomerLoyaltyFieldsPut($customer_loyalty_field)
```

Updates a batch of customer loyalty field.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerLoyaltyFieldsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_loyalty_field = array(new \Opsuite2\Model\CustomerLoyaltyField()); // \Opsuite2\Model\CustomerLoyaltyField[]

try {
    $apiInstance->apiV1CustomerLoyaltyFieldsPut($customer_loyalty_field);
} catch (Exception $e) {
    echo 'Exception when calling CustomerLoyaltyFieldsApi->apiV1CustomerLoyaltyFieldsPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_loyalty_field** | [**\Opsuite2\Model\CustomerLoyaltyField[]**](../Model/CustomerLoyaltyField.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
