# Opsuite2\CustomerContactsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CustomerContactsIdDelete()**](CustomerContactsApi.md#apiV1CustomerContactsIdDelete) | **DELETE** /api/v1/CustomerContacts/{id} | Deletes the specified customer contact. |
| [**apiV1CustomerContactsIdPatch()**](CustomerContactsApi.md#apiV1CustomerContactsIdPatch) | **PATCH** /api/v1/CustomerContacts/{id} | Updates specified properties of a customer contact. |
| [**apiV1CustomerContactsPost()**](CustomerContactsApi.md#apiV1CustomerContactsPost) | **POST** /api/v1/CustomerContacts | Creates a new customer contact. |
| [**apiV1CustomerContactsPut()**](CustomerContactsApi.md#apiV1CustomerContactsPut) | **PUT** /api/v1/CustomerContacts | Updates a customer contact. |
| [**getCustomerContactById()**](CustomerContactsApi.md#getCustomerContactById) | **GET** /api/v1/CustomerContacts/{id} | Returns the customer contact with the specified id. |


## `apiV1CustomerContactsIdDelete()`

```php
apiV1CustomerContactsIdDelete($id)
```

Deletes the specified customer contact.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int

try {
    $apiInstance->apiV1CustomerContactsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling CustomerContactsApi->apiV1CustomerContactsIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerContactsIdPatch()`

```php
apiV1CustomerContactsIdPatch($id, $patch)
```

Updates specified properties of a customer contact.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1CustomerContactsIdPatch($id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling CustomerContactsApi->apiV1CustomerContactsIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerContactsPost()`

```php
apiV1CustomerContactsPost($customer_contact): \Opsuite2\Model\CustomerContact
```

Creates a new customer contact.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_contact = new \Opsuite2\Model\CustomerContact(); // \Opsuite2\Model\CustomerContact

try {
    $result = $apiInstance->apiV1CustomerContactsPost($customer_contact);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerContactsApi->apiV1CustomerContactsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_contact** | [**\Opsuite2\Model\CustomerContact**](../Model/CustomerContact.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\CustomerContact**](../Model/CustomerContact.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CustomerContactsPut()`

```php
apiV1CustomerContactsPut($customer_contact)
```

Updates a customer contact.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_contact = array(new \Opsuite2\Model\CustomerContact()); // \Opsuite2\Model\CustomerContact[]

try {
    $apiInstance->apiV1CustomerContactsPut($customer_contact);
} catch (Exception $e) {
    echo 'Exception when calling CustomerContactsApi->apiV1CustomerContactsPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_contact** | [**\Opsuite2\Model\CustomerContact[]**](../Model/CustomerContact.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerContactById()`

```php
getCustomerContactById($id): \Opsuite2\Model\CustomerContact
```

Returns the customer contact with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CustomerContactsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int

try {
    $result = $apiInstance->getCustomerContactById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerContactsApi->getCustomerContactById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |

### Return type

[**\Opsuite2\Model\CustomerContact**](../Model/CustomerContact.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
