# Opsuite2\CommunitiesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CommunitiesCommunityIdMembersGet()**](CommunitiesApi.md#apiV1CommunitiesCommunityIdMembersGet) | **GET** /api/v1/Communities/{communityId}/Members | Returns a list of current memberships for the specified community. |
| [**apiV1CommunitiesGet()**](CommunitiesApi.md#apiV1CommunitiesGet) | **GET** /api/v1/Communities | Returns an array of Communities, subject to the search parameters. |


## `apiV1CommunitiesCommunityIdMembersGet()`

```php
apiV1CommunitiesCommunityIdMembersGet($community_id, $page_number, $page_size): \Opsuite2\Model\CommunityMember[]
```

Returns a list of current memberships for the specified community.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CommunitiesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$community_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->apiV1CommunitiesCommunityIdMembersGet($community_id, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CommunitiesApi->apiV1CommunitiesCommunityIdMembersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **community_id** | **int**|  | |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |

### Return type

[**\Opsuite2\Model\CommunityMember[]**](../Model/CommunityMember.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CommunitiesGet()`

```php
apiV1CommunitiesGet($page_number, $page_size, $include_inactive, $last_updated_date): \Opsuite2\Model\Community[]
```

Returns an array of Communities, subject to the search parameters.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CommunitiesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$include_inactive = True; // bool
$last_updated_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1CommunitiesGet($page_number, $page_size, $include_inactive, $last_updated_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CommunitiesApi->apiV1CommunitiesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |
| **last_updated_date** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\Community[]**](../Model/Community.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
