# Opsuite2\CategoriesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CategoriesCategoryIdPatch()**](CategoriesApi.md#apiV1CategoriesCategoryIdPatch) | **PATCH** /api/v1/Categories/{categoryId} | Updates specified properties of a category. |
| [**apiV1CategoriesGet()**](CategoriesApi.md#apiV1CategoriesGet) | **GET** /api/v1/Categories | Returns an array of Categories that match the specified search criteria. |
| [**apiV1CategoriesGetCategoryByCodeGet()**](CategoriesApi.md#apiV1CategoriesGetCategoryByCodeGet) | **GET** /api/v1/Categories/GetCategoryByCode | Returns a single Category with the specified code. |
| [**apiV1CategoriesPatchMultipleCategoriesPatch()**](CategoriesApi.md#apiV1CategoriesPatchMultipleCategoriesPatch) | **PATCH** /api/v1/Categories/PatchMultipleCategories | Updates specified properties of multiple categories. |
| [**apiV1CategoriesPost()**](CategoriesApi.md#apiV1CategoriesPost) | **POST** /api/v1/Categories | Creates a new category. |
| [**apiV1CategoriesPostMultipleCategoriesPost()**](CategoriesApi.md#apiV1CategoriesPostMultipleCategoriesPost) | **POST** /api/v1/Categories/PostMultipleCategories | Creates multiple new categories. |
| [**getCategoryById()**](CategoriesApi.md#getCategoryById) | **GET** /api/v1/Categories/{categoryId} | Returns a single Category with the specified id. |


## `apiV1CategoriesCategoryIdPatch()`

```php
apiV1CategoriesCategoryIdPatch($category_id, $patch)
```

Updates specified properties of a category.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1CategoriesCategoryIdPatch($category_id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesCategoryIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesGet()`

```php
apiV1CategoriesGet($page_number, $page_size, $department_id, $department_code, $department_code_search_operator, $department_name, $department_name_search_operator): \Opsuite2\Model\Category[]
```

Returns an array of Categories that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$department_id = 56; // int
$department_code = 'department_code_example'; // string
$department_code_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum
$department_name = 'department_name_example'; // string
$department_name_search_operator = new \Opsuite2\Model\\Opsuite2\Model\SimpleSearchOperatorEnum(); // \Opsuite2\Model\SimpleSearchOperatorEnum

try {
    $result = $apiInstance->apiV1CategoriesGet($page_number, $page_size, $department_id, $department_code, $department_code_search_operator, $department_name, $department_name_search_operator);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **department_id** | **int**|  | [optional] |
| **department_code** | **string**|  | [optional] |
| **department_code_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |
| **department_name** | **string**|  | [optional] |
| **department_name_search_operator** | [**\Opsuite2\Model\SimpleSearchOperatorEnum**](../Model/.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Category[]**](../Model/Category.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesGetCategoryByCodeGet()`

```php
apiV1CategoriesGetCategoryByCodeGet($category_code): \Opsuite2\Model\Category
```

Returns a single Category with the specified code.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_code = 'category_code_example'; // string

try {
    $result = $apiInstance->apiV1CategoriesGetCategoryByCodeGet($category_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesGetCategoryByCodeGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_code** | **string**|  | [optional] |

### Return type

[**\Opsuite2\Model\Category**](../Model/Category.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesPatchMultipleCategoriesPatch()`

```php
apiV1CategoriesPatchMultipleCategoriesPatch($patch_collection): \Opsuite2\Model\PatchResponse[]
```

Updates specified properties of multiple categories.

Returns an array of PatchResponse objects.  Each object contains the values that  would be returned from making a single patch.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$patch_collection = array(new \Opsuite2\Model\PatchCollection()); // \Opsuite2\Model\PatchCollection[]

try {
    $result = $apiInstance->apiV1CategoriesPatchMultipleCategoriesPatch($patch_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesPatchMultipleCategoriesPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **patch_collection** | [**\Opsuite2\Model\PatchCollection[]**](../Model/PatchCollection.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PatchResponse[]**](../Model/PatchResponse.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesPost()`

```php
apiV1CategoriesPost($category): \Opsuite2\Model\Category
```

Creates a new category.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category = new \Opsuite2\Model\Category(); // \Opsuite2\Model\Category

try {
    $result = $apiInstance->apiV1CategoriesPost($category);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category** | [**\Opsuite2\Model\Category**](../Model/Category.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\Category**](../Model/Category.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1CategoriesPostMultipleCategoriesPost()`

```php
apiV1CategoriesPostMultipleCategoriesPost($category): \Opsuite2\Model\PostResponseCategory[]
```

Creates multiple new categories.

Returns an array of PostResponse objects.  Each object contains the values that  would be returned from making a single post.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category = array(new \Opsuite2\Model\Category()); // \Opsuite2\Model\Category[]

try {
    $result = $apiInstance->apiV1CategoriesPostMultipleCategoriesPost($category);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->apiV1CategoriesPostMultipleCategoriesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category** | [**\Opsuite2\Model\Category[]**](../Model/Category.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\PostResponseCategory[]**](../Model/PostResponseCategory.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategoryById()`

```php
getCategoryById($category_id): \Opsuite2\Model\Category
```

Returns a single Category with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CategoriesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$category_id = 56; // int

try {
    $result = $apiInstance->getCategoryById($category_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoriesApi->getCategoryById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **category_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Category**](../Model/Category.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
