# Opsuite2\CashiersApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1CashiersGet()**](CashiersApi.md#apiV1CashiersGet) | **GET** /api/v1/Cashiers | Returns an array of Cashiers, subject to the search parameters. |
| [**getCashierById()**](CashiersApi.md#getCashierById) | **GET** /api/v1/Cashiers/{cashierId} | Returns a single Cashier with the specified id. |


## `apiV1CashiersGet()`

```php
apiV1CashiersGet($page_number, $page_size, $include_inactive, $modified_date_range_start, $modified_date_range_end): \Opsuite2\Model\Cashier[]
```

Returns an array of Cashiers, subject to the search parameters.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CashiersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$include_inactive = True; // bool
$modified_date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$modified_date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1CashiersGet($page_number, $page_size, $include_inactive, $modified_date_range_start, $modified_date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CashiersApi->apiV1CashiersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |
| **modified_date_range_start** | **\DateTime**|  | [optional] |
| **modified_date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\Cashier[]**](../Model/Cashier.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCashierById()`

```php
getCashierById($cashier_id): \Opsuite2\Model\Cashier
```

Returns a single Cashier with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\CashiersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$cashier_id = 56; // int

try {
    $result = $apiInstance->getCashierById($cashier_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CashiersApi->getCashierById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **cashier_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\Cashier**](../Model/Cashier.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
