# Opsuite2\BasketsApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1BasketsControllerIdPatch()**](BasketsApi.md#apiV1BasketsControllerIdPatch) | **PATCH** /api/v1/BasketsController/{id} | Updates specified properties of a ProcessedBasket. |
| [**apiV1BasketsControllerProcessBasketForDiscountsPost()**](BasketsApi.md#apiV1BasketsControllerProcessBasketForDiscountsPost) | **POST** /api/v1/BasketsController/ProcessBasketForDiscounts | Returns a ProcessedBasket. |


## `apiV1BasketsControllerIdPatch()`

```php
apiV1BasketsControllerIdPatch($id, $patch)
```

Updates specified properties of a ProcessedBasket.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\BasketsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int
$patch = array(new \Opsuite2\Model\Patch()); // \Opsuite2\Model\Patch[]

try {
    $apiInstance->apiV1BasketsControllerIdPatch($id, $patch);
} catch (Exception $e) {
    echo 'Exception when calling BasketsApi->apiV1BasketsControllerIdPatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **int**|  | |
| **patch** | [**\Opsuite2\Model\Patch[]**](../Model/Patch.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1BasketsControllerProcessBasketForDiscountsPost()`

```php
apiV1BasketsControllerProcessBasketForDiscountsPost($basket): \Opsuite2\Model\ProcessedBasket
```

Returns a ProcessedBasket.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\BasketsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$basket = new \Opsuite2\Model\Basket(); // \Opsuite2\Model\Basket

try {
    $result = $apiInstance->apiV1BasketsControllerProcessBasketForDiscountsPost($basket);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BasketsApi->apiV1BasketsControllerProcessBasketForDiscountsPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **basket** | [**\Opsuite2\Model\Basket**](../Model/Basket.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\ProcessedBasket**](../Model/ProcessedBasket.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
