# Opsuite2\AccountTypesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1AccountTypesGet()**](AccountTypesApi.md#apiV1AccountTypesGet) | **GET** /api/v1/AccountTypes | Retrieves an array of AccountTypes, subject to the search parameters. |


## `apiV1AccountTypesGet()`

```php
apiV1AccountTypesGet($page_number, $page_size, $include_inactive): \Opsuite2\Model\AccountType[]
```

Retrieves an array of AccountTypes, subject to the search parameters.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\AccountTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$include_inactive = True; // bool

try {
    $result = $apiInstance->apiV1AccountTypesGet($page_number, $page_size, $include_inactive);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountTypesApi->apiV1AccountTypesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **include_inactive** | **bool**|  | [optional] |

### Return type

[**\Opsuite2\Model\AccountType[]**](../Model/AccountType.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
