# Opsuite2\AccountReceivablesApi

All URIs are relative to http://localhost, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**apiV1AccountReceivablesGetAccountReceivableBalancesGet()**](AccountReceivablesApi.md#apiV1AccountReceivablesGetAccountReceivableBalancesGet) | **GET** /api/v1/AccountReceivables/GetAccountReceivableBalances | Returns an array of AccountReceivableBalances for the specified that match the specified search criteria. |
| [**apiV1AccountReceivablesGetAccountReceivablesForCustomerGet()**](AccountReceivablesApi.md#apiV1AccountReceivablesGetAccountReceivablesForCustomerGet) | **GET** /api/v1/AccountReceivables/GetAccountReceivablesForCustomer | Returns an array of AccountReceivables for the specified that match the specified search criteria. |
| [**apiV1AccountReceivablesPost()**](AccountReceivablesApi.md#apiV1AccountReceivablesPost) | **POST** /api/v1/AccountReceivables | Creates an account receivable record. |
| [**getAccountReceivableById()**](AccountReceivablesApi.md#getAccountReceivableById) | **GET** /api/v1/AccountReceivables/{accountReceivableId} | Returns a single AccountReceivable with the specified id. |


## `apiV1AccountReceivablesGetAccountReceivableBalancesGet()`

```php
apiV1AccountReceivablesGetAccountReceivableBalancesGet($page_number, $page_size, $date_range_start, $date_range_end): \Opsuite2\Model\AccountReceivableBalance[]
```

Returns an array of AccountReceivableBalances for the specified that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\AccountReceivablesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1AccountReceivablesGetAccountReceivableBalancesGet($page_number, $page_size, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountReceivablesApi->apiV1AccountReceivablesGetAccountReceivableBalancesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\AccountReceivableBalance[]**](../Model/AccountReceivableBalance.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1AccountReceivablesGetAccountReceivablesForCustomerGet()`

```php
apiV1AccountReceivablesGetAccountReceivablesForCustomerGet($customer_id, $page_number, $page_size, $date_range_start, $date_range_end): \Opsuite2\Model\AccountReceivable[]
```

Returns an array of AccountReceivables for the specified that match the specified search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\AccountReceivablesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 56; // int
$page_number = 56; // int
$page_size = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1AccountReceivablesGetAccountReceivablesForCustomerGet($customer_id, $page_number, $page_size, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountReceivablesApi->apiV1AccountReceivablesGetAccountReceivablesForCustomerGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **customer_id** | **int**|  | [optional] |
| **page_number** | **int**|  | [optional] |
| **page_size** | **int**|  | [optional] |
| **date_range_start** | **\DateTime**|  | [optional] |
| **date_range_end** | **\DateTime**|  | [optional] |

### Return type

[**\Opsuite2\Model\AccountReceivable[]**](../Model/AccountReceivable.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `apiV1AccountReceivablesPost()`

```php
apiV1AccountReceivablesPost($account_receivable): \Opsuite2\Model\AccountReceivable
```

Creates an account receivable record.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\AccountReceivablesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$account_receivable = new \Opsuite2\Model\AccountReceivable(); // \Opsuite2\Model\AccountReceivable

try {
    $result = $apiInstance->apiV1AccountReceivablesPost($account_receivable);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountReceivablesApi->apiV1AccountReceivablesPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **account_receivable** | [**\Opsuite2\Model\AccountReceivable**](../Model/AccountReceivable.md)|  | [optional] |

### Return type

[**\Opsuite2\Model\AccountReceivable**](../Model/AccountReceivable.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: `application/json`, `text/json`, `application/*+json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAccountReceivableById()`

```php
getAccountReceivableById($account_receivable_id): \Opsuite2\Model\AccountReceivable
```

Returns a single AccountReceivable with the specified id.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\AccountReceivablesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$account_receivable_id = 56; // int

try {
    $result = $apiInstance->getAccountReceivableById($account_receivable_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountReceivablesApi->getAccountReceivableById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **account_receivable_id** | **int**|  | |

### Return type

[**\Opsuite2\Model\AccountReceivable**](../Model/AccountReceivable.md)

### Authorization

[bearer](../../README.md#bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
