# OpenAPIClient-php

<p>Welcome the the OpSuite.API.  This swagger page is the best place to familiarize yourself with the API before you write any client code.  </p<p>Here is some general information about the use of the API.<p><p><b>Authentication</b><p>All requests require authentication. You will need a username and password in order to obtain a bearer token that is then used with all requests. If you do not have a username and password then contact the enterprise you are developing for.</p><p><b>Rate Limits</b><p><p>OpSuite.API is limited on a per client basis.<p><p>In order for your client to be allocated the correct rate limits you should add a header to your request with a Key of X-ClientId and a Value of your username.<p><p>You should then contact us so we can setup your rate limits.<p><p>If you do not set the X-ClientId header then your requests will be limited by a default set of low rates limits.<p><p>It is important that you use the API in the most efficient way so that you do not reach the rate limits.<p><p>Requests exceeding the limit will return a '429 Too Many Requests' along with a JSON error message.<p><p>A client's limits and usage are reported with every API request as part of the HTTP Headers.<p><p>Example successful response headers:<p><p>HTTP/1.1 200 OK<br>X-Rate-Limit: 24h<br>X-Rate-Limit-Remaining: 249963<br>X-Rate-Limit-Reset: 2022-11-25T09:20:41<p><p>Example rate-limited response JSON error message and headers:<p><p>Content: API calls quota exceeded! maximum admitted 4500 per 15m.<br>HTTP/1.1 429 Too many Requests<br>Retry-After: 10 (seconds)<p>


## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/opsuite2.git"
    }
  ],
  "require": {
    "talisman/opsuite2": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure Bearer (JWT) authorization: bearer
$config = Opsuite2\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Opsuite2\Api\AccountReceivablesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$page_number = 56; // int
$page_size = 56; // int
$date_range_start = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime
$date_range_end = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime

try {
    $result = $apiInstance->apiV1AccountReceivablesGetAccountReceivableBalancesGet($page_number, $page_size, $date_range_start, $date_range_end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AccountReceivablesApi->apiV1AccountReceivablesGetAccountReceivableBalancesGet: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountReceivablesApi* | [**apiV1AccountReceivablesGetAccountReceivableBalancesGet**](docs/Api/AccountReceivablesApi.md#apiv1accountreceivablesgetaccountreceivablebalancesget) | **GET** /api/v1/AccountReceivables/GetAccountReceivableBalances | Returns an array of AccountReceivableBalances for the specified that match the specified search criteria.
*AccountReceivablesApi* | [**apiV1AccountReceivablesGetAccountReceivablesForCustomerGet**](docs/Api/AccountReceivablesApi.md#apiv1accountreceivablesgetaccountreceivablesforcustomerget) | **GET** /api/v1/AccountReceivables/GetAccountReceivablesForCustomer | Returns an array of AccountReceivables for the specified that match the specified search criteria.
*AccountReceivablesApi* | [**apiV1AccountReceivablesPost**](docs/Api/AccountReceivablesApi.md#apiv1accountreceivablespost) | **POST** /api/v1/AccountReceivables | Creates an account receivable record.
*AccountReceivablesApi* | [**getAccountReceivableById**](docs/Api/AccountReceivablesApi.md#getaccountreceivablebyid) | **GET** /api/v1/AccountReceivables/{accountReceivableId} | Returns a single AccountReceivable with the specified id.
*AccountTypesApi* | [**apiV1AccountTypesGet**](docs/Api/AccountTypesApi.md#apiv1accounttypesget) | **GET** /api/v1/AccountTypes | Retrieves an array of AccountTypes, subject to the search parameters.
*BasketsApi* | [**apiV1BasketsControllerIdPatch**](docs/Api/BasketsApi.md#apiv1basketscontrolleridpatch) | **PATCH** /api/v1/BasketsController/{id} | Updates specified properties of a ProcessedBasket.
*BasketsApi* | [**apiV1BasketsControllerProcessBasketForDiscountsPost**](docs/Api/BasketsApi.md#apiv1basketscontrollerprocessbasketfordiscountspost) | **POST** /api/v1/BasketsController/ProcessBasketForDiscounts | Returns a ProcessedBasket.
*CashiersApi* | [**apiV1CashiersGet**](docs/Api/CashiersApi.md#apiv1cashiersget) | **GET** /api/v1/Cashiers | Returns an array of Cashiers, subject to the search parameters.
*CashiersApi* | [**getCashierById**](docs/Api/CashiersApi.md#getcashierbyid) | **GET** /api/v1/Cashiers/{cashierId} | Returns a single Cashier with the specified id.
*CategoriesApi* | [**apiV1CategoriesCategoryIdPatch**](docs/Api/CategoriesApi.md#apiv1categoriescategoryidpatch) | **PATCH** /api/v1/Categories/{categoryId} | Updates specified properties of a category.
*CategoriesApi* | [**apiV1CategoriesGet**](docs/Api/CategoriesApi.md#apiv1categoriesget) | **GET** /api/v1/Categories | Returns an array of Categories that match the specified search criteria.
*CategoriesApi* | [**apiV1CategoriesGetCategoryByCodeGet**](docs/Api/CategoriesApi.md#apiv1categoriesgetcategorybycodeget) | **GET** /api/v1/Categories/GetCategoryByCode | Returns a single Category with the specified code.
*CategoriesApi* | [**apiV1CategoriesPatchMultipleCategoriesPatch**](docs/Api/CategoriesApi.md#apiv1categoriespatchmultiplecategoriespatch) | **PATCH** /api/v1/Categories/PatchMultipleCategories | Updates specified properties of multiple categories.
*CategoriesApi* | [**apiV1CategoriesPost**](docs/Api/CategoriesApi.md#apiv1categoriespost) | **POST** /api/v1/Categories | Creates a new category.
*CategoriesApi* | [**apiV1CategoriesPostMultipleCategoriesPost**](docs/Api/CategoriesApi.md#apiv1categoriespostmultiplecategoriespost) | **POST** /api/v1/Categories/PostMultipleCategories | Creates multiple new categories.
*CategoriesApi* | [**getCategoryById**](docs/Api/CategoriesApi.md#getcategorybyid) | **GET** /api/v1/Categories/{categoryId} | Returns a single Category with the specified id.
*CommunitiesApi* | [**apiV1CommunitiesCommunityIdMembersGet**](docs/Api/CommunitiesApi.md#apiv1communitiescommunityidmembersget) | **GET** /api/v1/Communities/{communityId}/Members | Returns a list of current memberships for the specified community.
*CommunitiesApi* | [**apiV1CommunitiesGet**](docs/Api/CommunitiesApi.md#apiv1communitiesget) | **GET** /api/v1/Communities | Returns an array of Communities, subject to the search parameters.
*CountriesApi* | [**apiV1CountriesGet**](docs/Api/CountriesApi.md#apiv1countriesget) | **GET** /api/v1/Countries | Returns an array of Iso Countries.
*CustomerContactsApi* | [**apiV1CustomerContactsIdDelete**](docs/Api/CustomerContactsApi.md#apiv1customercontactsiddelete) | **DELETE** /api/v1/CustomerContacts/{id} | Deletes the specified customer contact.
*CustomerContactsApi* | [**apiV1CustomerContactsIdPatch**](docs/Api/CustomerContactsApi.md#apiv1customercontactsidpatch) | **PATCH** /api/v1/CustomerContacts/{id} | Updates specified properties of a customer contact.
*CustomerContactsApi* | [**apiV1CustomerContactsPost**](docs/Api/CustomerContactsApi.md#apiv1customercontactspost) | **POST** /api/v1/CustomerContacts | Creates a new customer contact.
*CustomerContactsApi* | [**apiV1CustomerContactsPut**](docs/Api/CustomerContactsApi.md#apiv1customercontactsput) | **PUT** /api/v1/CustomerContacts | Updates a customer contact.
*CustomerContactsApi* | [**getCustomerContactById**](docs/Api/CustomerContactsApi.md#getcustomercontactbyid) | **GET** /api/v1/CustomerContacts/{id} | Returns the customer contact with the specified id.
*CustomerLoyaltyFieldConfigsApi* | [**apiV1CustomerLoyaltyFieldConfigsGet**](docs/Api/CustomerLoyaltyFieldConfigsApi.md#apiv1customerloyaltyfieldconfigsget) | **GET** /api/v1/CustomerLoyaltyFieldConfigs | Returns an array of Customer Loyalty Field Configurations.
*CustomerLoyaltyFieldTypesApi* | [**apiV1CustomerLoyaltyFieldTypesGet**](docs/Api/CustomerLoyaltyFieldTypesApi.md#apiv1customerloyaltyfieldtypesget) | **GET** /api/v1/CustomerLoyaltyFieldTypes | Returns an array of Customer Loyalty Field Types.
*CustomerLoyaltyFieldsApi* | [**apiV1CustomerLoyaltyFieldsGet**](docs/Api/CustomerLoyaltyFieldsApi.md#apiv1customerloyaltyfieldsget) | **GET** /api/v1/CustomerLoyaltyFields | Returns an array of customer loyalty fields.
*CustomerLoyaltyFieldsApi* | [**apiV1CustomerLoyaltyFieldsGetCustomerLoyaltyFieldsByLoyaltyCardsGet**](docs/Api/CustomerLoyaltyFieldsApi.md#apiv1customerloyaltyfieldsgetcustomerloyaltyfieldsbyloyaltycardsget) | **GET** /api/v1/CustomerLoyaltyFields/GetCustomerLoyaltyFieldsByLoyaltyCards | Returns an array of customer loyalty fields.
*CustomerLoyaltyFieldsApi* | [**apiV1CustomerLoyaltyFieldsPut**](docs/Api/CustomerLoyaltyFieldsApi.md#apiv1customerloyaltyfieldsput) | **PUT** /api/v1/CustomerLoyaltyFields | Updates a batch of customer loyalty field.
*CustomerLoyaltyFieldsBulkUpdateApi* | [**apiV1CustomerLoyaltyFieldsBulkUpdatesPost**](docs/Api/CustomerLoyaltyFieldsBulkUpdateApi.md#apiv1customerloyaltyfieldsbulkupdatespost) | **POST** /api/v1/CustomerLoyaltyFieldsBulkUpdates | Creates a new set of loyalty points.
*CustomerRewardsCampaignsApi* | [**apiV1CustomerRewardsCampaignsCampaignIdDiscountCouponsGet**](docs/Api/CustomerRewardsCampaignsApi.md#apiv1customerrewardscampaignscampaigniddiscountcouponsget) | **GET** /api/v1/CustomerRewardsCampaigns/{campaignId}/DiscountCoupons | Returns an array of discount coupons for the specified customer rewards campaign
*CustomerRewardsCampaignsApi* | [**apiV1CustomerRewardsCampaignsCampaignIdPromotionCouponsGet**](docs/Api/CustomerRewardsCampaignsApi.md#apiv1customerrewardscampaignscampaignidpromotioncouponsget) | **GET** /api/v1/CustomerRewardsCampaigns/{campaignId}/PromotionCoupons | Returns an array of promotion coupons for the specified customer rewards campaign
*CustomerRewardsCampaignsApi* | [**apiV1CustomerRewardsCampaignsGet**](docs/Api/CustomerRewardsCampaignsApi.md#apiv1customerrewardscampaignsget) | **GET** /api/v1/CustomerRewardsCampaigns | Returns an array of Customer Rewards Campaigns.
*CustomerRewardsCampaignsApi* | [**apiV1CustomerRewardsCampaignsGetCustomerRewardsCampaignByCodeGet**](docs/Api/CustomerRewardsCampaignsApi.md#apiv1customerrewardscampaignsgetcustomerrewardscampaignbycodeget) | **GET** /api/v1/CustomerRewardsCampaigns/GetCustomerRewardsCampaignByCode | Returns a single Customer Rewards Campaign with the specified code.
*CustomerRewardsCampaignsApi* | [**getCustomerRewardsCampaignById**](docs/Api/CustomerRewardsCampaignsApi.md#getcustomerrewardscampaignbyid) | **GET** /api/v1/CustomerRewardsCampaigns/{campaignId} | Returns a single Customer Rewards Campaign with the specified id.
*CustomersApi* | [**apiV1CustomersCustomerIdAllContactsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridallcontactsget) | **GET** /api/v1/Customers/{customerId}/AllContacts | Returns an array of all contacts for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdAlternativeShipToContactsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridalternativeshiptocontactsget) | **GET** /api/v1/Customers/{customerId}/AlternativeShipToContacts | Returns an array of alternative ship to contacts for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdContactsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridcontactsget) | **GET** /api/v1/Customers/{customerId}/Contacts | Returns an array of other contacts for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdCustomerLoyaltyFieldsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridcustomerloyaltyfieldsget) | **GET** /api/v1/Customers/{customerId}/CustomerLoyaltyFields | Returns the customer loyalty fields for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdDiscountCouponsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeriddiscountcouponsget) | **GET** /api/v1/Customers/{customerId}/DiscountCoupons | Returns an array of discount coupons for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdLoyaltyBalancesGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridloyaltybalancesget) | **GET** /api/v1/Customers/{customerId}/LoyaltyBalances | Returns an array of loyalty point balances for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdLoyaltyCardsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridloyaltycardsget) | **GET** /api/v1/Customers/{customerId}/LoyaltyCards | Returns an array of loyalty cards for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdLoyaltyTransactionsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridloyaltytransactionsget) | **GET** /api/v1/Customers/{customerId}/LoyaltyTransactions | Returns an array of loyalty transactions for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdPatch**](docs/Api/CustomersApi.md#apiv1customerscustomeridpatch) | **PATCH** /api/v1/Customers/{customerId} | Updates specified properties of a customer.
*CustomersApi* | [**apiV1CustomersCustomerIdPromotionCouponsGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridpromotioncouponsget) | **GET** /api/v1/Customers/{customerId}/PromotionCoupons | Returns an array of promotion coupons for the specified customer.
*CustomersApi* | [**apiV1CustomersCustomerIdTransactionHeadersGet**](docs/Api/CustomersApi.md#apiv1customerscustomeridtransactionheadersget) | **GET** /api/v1/Customers/{customerId}/TransactionHeaders | Returns an array of transaction headers for the specified customer.
*CustomersApi* | [**apiV1CustomersExpiringLoyaltyTransactionsGet**](docs/Api/CustomersApi.md#apiv1customersexpiringloyaltytransactionsget) | **GET** /api/v1/Customers/ExpiringLoyaltyTransactions | Returns an array of expiring loyalty transactions for the specified customers.
*CustomersApi* | [**apiV1CustomersExpiryingLoyaltyTransactionsGet**](docs/Api/CustomersApi.md#apiv1customersexpiryingloyaltytransactionsget) | **GET** /api/v1/Customers/ExpiryingLoyaltyTransactions | Returns an array of expiring loyalty transactions for the specified customers.
*CustomersApi* | [**apiV1CustomersGet**](docs/Api/CustomersApi.md#apiv1customersget) | **GET** /api/v1/Customers | Returns an array of Customers that match the specified search criteria.
*CustomersApi* | [**apiV1CustomersGetCustomerByAccountNumberGet**](docs/Api/CustomersApi.md#apiv1customersgetcustomerbyaccountnumberget) | **GET** /api/v1/Customers/GetCustomerByAccountNumber | Returns a single Customer with the specified account number or loyalty card number.
*CustomersApi* | [**apiV1CustomersGetCustomerByAddressGet**](docs/Api/CustomersApi.md#apiv1customersgetcustomerbyaddressget) | **GET** /api/v1/Customers/GetCustomerByAddress | Returns a single Customer with the specified physical address.
*CustomersApi* | [**apiV1CustomersGetCustomerByEmailAddressGet**](docs/Api/CustomersApi.md#apiv1customersgetcustomerbyemailaddressget) | **GET** /api/v1/Customers/GetCustomerByEmailAddress | Returns a single Customer with the specified email address.
*CustomersApi* | [**apiV1CustomersPost**](docs/Api/CustomersApi.md#apiv1customerspost) | **POST** /api/v1/Customers | Creates a new customer.
*CustomersApi* | [**apiV1CustomersPut**](docs/Api/CustomersApi.md#apiv1customersput) | **PUT** /api/v1/Customers | Updates a batch of customers.
*CustomersApi* | [**getCustomerById**](docs/Api/CustomersApi.md#getcustomerbyid) | **GET** /api/v1/Customers/{customerId} | Returns a single Customer with the specified id.
*DepartmentsApi* | [**apiV1DepartmentsDepartmentIdPatch**](docs/Api/DepartmentsApi.md#apiv1departmentsdepartmentidpatch) | **PATCH** /api/v1/Departments/{departmentId} | Updates specified properties of a department.
*DepartmentsApi* | [**apiV1DepartmentsGet**](docs/Api/DepartmentsApi.md#apiv1departmentsget) | **GET** /api/v1/Departments | Returns an array of Departments that match the specified search criteria.
*DepartmentsApi* | [**apiV1DepartmentsGetDepartmentByCodeGet**](docs/Api/DepartmentsApi.md#apiv1departmentsgetdepartmentbycodeget) | **GET** /api/v1/Departments/GetDepartmentByCode | Returns a single Department with the specified code.
*DepartmentsApi* | [**apiV1DepartmentsPatchMultipleDepartmentsPatch**](docs/Api/DepartmentsApi.md#apiv1departmentspatchmultipledepartmentspatch) | **PATCH** /api/v1/Departments/PatchMultipleDepartments | Updates specified properties of multiple departments.
*DepartmentsApi* | [**apiV1DepartmentsPost**](docs/Api/DepartmentsApi.md#apiv1departmentspost) | **POST** /api/v1/Departments | Creates a new department.
*DepartmentsApi* | [**apiV1DepartmentsPostMultipleDepartmentsPost**](docs/Api/DepartmentsApi.md#apiv1departmentspostmultipledepartmentspost) | **POST** /api/v1/Departments/PostMultipleDepartments | Creates multiple new departments.
*DepartmentsApi* | [**getDepartmentById**](docs/Api/DepartmentsApi.md#getdepartmentbyid) | **GET** /api/v1/Departments/{departmentId} | Returns a single Department with the specified id.
*GRNDetailsApi* | [**apiV1GRNDetailsGetGRNDetailsByOrderNumberGet**](docs/Api/GRNDetailsApi.md#apiv1grndetailsgetgrndetailsbyordernumberget) | **GET** /api/v1/GRNDetails/GetGRNDetailsByOrderNumber | Returns a GRNDetails for a given inventory control document order number.
*GRNDetailsApi* | [**apiV1GRNDetailsGetGRNDetailsGet**](docs/Api/GRNDetailsApi.md#apiv1grndetailsgetgrndetailsget) | **GET** /api/v1/GRNDetails/GetGRNDetails | Returns an array of GRNDetails that match the specified search criteria.
*GRNDetailsApi* | [**apiV1GRNDetailsGetGRNLinesByGRNNumberGet**](docs/Api/GRNDetailsApi.md#apiv1grndetailsgetgrnlinesbygrnnumberget) | **GET** /api/v1/GRNDetails/GetGRNLinesByGRNNumber | Returns the lines on a GRN.
*GRNDetailsApi* | [**apiV1GRNDetailsGetGRNLinesByIdGet**](docs/Api/GRNDetailsApi.md#apiv1grndetailsgetgrnlinesbyidget) | **GET** /api/v1/GRNDetails/GetGRNLinesById | Returns the lines on a GRN.
*GRNDetailsApi* | [**getGRNDetailsById**](docs/Api/GRNDetailsApi.md#getgrndetailsbyid) | **GET** /api/v1/GRNDetails/{receivingDocumentId} | Returns a GRNDetails for a given receiving document id.
*HospitalityRoomsApi* | [**apiV1HospitalityRoomsGet**](docs/Api/HospitalityRoomsApi.md#apiv1hospitalityroomsget) | **GET** /api/v1/HospitalityRooms | Returns an array of HospitalityRooms that match the specified search criteria.
*HospitalityRoomsApi* | [**apiV1HospitalityRoomsGetHospitalityRoomByNameGet**](docs/Api/HospitalityRoomsApi.md#apiv1hospitalityroomsgethospitalityroombynameget) | **GET** /api/v1/HospitalityRooms/GetHospitalityRoomByName | Returns a single HospitalityRoom with the specified name.
*HospitalityRoomsApi* | [**getHospitalityRoomById**](docs/Api/HospitalityRoomsApi.md#gethospitalityroombyid) | **GET** /api/v1/HospitalityRooms/{roomId} | Returns a single HospitalityRoom with the specified id.
*HospitalityTablesApi* | [**apiV1HospitalityTablesGet**](docs/Api/HospitalityTablesApi.md#apiv1hospitalitytablesget) | **GET** /api/v1/HospitalityTables | Returns an array of HospitalityTables that match the specified search criteria.
*InvoiceMatchingApi* | [**apiV1InvoiceMatchingGet**](docs/Api/InvoiceMatchingApi.md#apiv1invoicematchingget) | **GET** /api/v1/InvoiceMatching | Returns an array of Invoices.
*InvoiceMatchingApi* | [**apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByIdGet**](docs/Api/InvoiceMatchingApi.md#apiv1invoicematchinggetinvoicematchingitemdetailsbyidget) | **GET** /api/v1/InvoiceMatching/GetInvoiceMatchingItemDetailsById | Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
*InvoiceMatchingApi* | [**apiV1InvoiceMatchingGetInvoiceMatchingItemDetailsByNumberGet**](docs/Api/InvoiceMatchingApi.md#apiv1invoicematchinggetinvoicematchingitemdetailsbynumberget) | **GET** /api/v1/InvoiceMatching/GetInvoiceMatchingItemDetailsByNumber | Return a paged list of items on the specified invoice  Querystring parameters:      pageSize - specify how many records to be returned      pageNumber - specify page number based upon the page size
*ItemAliasesApi* | [**apiV1ItemAliasesAliasIdDelete**](docs/Api/ItemAliasesApi.md#apiv1itemaliasesaliasiddelete) | **DELETE** /api/v1/ItemAliases/{aliasId} | Deletes a single item alias by reference to id.
*ItemAliasesApi* | [**apiV1ItemAliasesGetItemAliasByAliasGet**](docs/Api/ItemAliasesApi.md#apiv1itemaliasesgetitemaliasbyaliasget) | **GET** /api/v1/ItemAliases/GetItemAliasByAlias | Returns a single ItemAlias with the specified alias.
*ItemAliasesApi* | [**apiV1ItemAliasesPatchMultipleItemAliasesPatch**](docs/Api/ItemAliasesApi.md#apiv1itemaliasespatchmultipleitemaliasespatch) | **PATCH** /api/v1/ItemAliases/PatchMultipleItemAliases | Updates specified properties of multiple item aliases.
*ItemAliasesApi* | [**apiV1ItemAliasesPostMultipleItemAliasesPost**](docs/Api/ItemAliasesApi.md#apiv1itemaliasespostmultipleitemaliasespost) | **POST** /api/v1/ItemAliases/PostMultipleItemAliases | Creates multiple new ItemAliases.
*ItemAliasesApi* | [**getItemAliasById**](docs/Api/ItemAliasesApi.md#getitemaliasbyid) | **GET** /api/v1/ItemAliases/{aliasId} | Returns a single ItemAlias with the specified id.
*ItemBinQuantitiesApi* | [**apiV1ItemBinQuantitiesGetItemBinQuantitiesGet**](docs/Api/ItemBinQuantitiesApi.md#apiv1itembinquantitiesgetitembinquantitiesget) | **GET** /api/v1/ItemBinQuantities/GetItemBinQuantities | Returns an array of ItemBinQuantities that match the specified search criteria  If the customer order number or inventory transfer search parameters aren&#39;t set  then the last updated date and location id are required parameters
*ItemBinQuantitiesApi* | [**apiV1ItemBinQuantitiesUpdateItemBinQuantitiesByIdPost**](docs/Api/ItemBinQuantitiesApi.md#apiv1itembinquantitiesupdateitembinquantitiesbyidpost) | **POST** /api/v1/ItemBinQuantities/UpdateItemBinQuantitiesById | Posts an array of ItemBinQuantitiesUpdates
*ItemBinQuantitiesApi* | [**apiV1ItemBinQuantitiesUpdateItemBinQuantitiesPost**](docs/Api/ItemBinQuantitiesApi.md#apiv1itembinquantitiesupdateitembinquantitiespost) | **POST** /api/v1/ItemBinQuantities/UpdateItemBinQuantities | Posts an array of ItemBinQuantitiesUpdates
*ItemDetailsApi* | [**apiV1ItemDetailsGetItemDetailsByAttributeGet**](docs/Api/ItemDetailsApi.md#apiv1itemdetailsgetitemdetailsbyattributeget) | **GET** /api/v1/ItemDetails/GetItemDetailsByAttribute | Returns a list of ItemDetails that have the specified attribute code or description
*ItemDetailsApi* | [**apiV1ItemDetailsGetItemDetailsByIdListGet**](docs/Api/ItemDetailsApi.md#apiv1itemdetailsgetitemdetailsbyidlistget) | **GET** /api/v1/ItemDetails/GetItemDetailsByIdList | Returns a list of ItemDetails for the specified list of item master ids.
*ItemDetailsApi* | [**apiV1ItemDetailsGetItemDetailsBySkuGet**](docs/Api/ItemDetailsApi.md#apiv1itemdetailsgetitemdetailsbyskuget) | **GET** /api/v1/ItemDetails/GetItemDetailsBySku | Returns a single ItemDetails with the specified sku.
*ItemDetailsApi* | [**apiV1ItemDetailsGetItemDetailsBySkuListGet**](docs/Api/ItemDetailsApi.md#apiv1itemdetailsgetitemdetailsbyskulistget) | **GET** /api/v1/ItemDetails/GetItemDetailsBySkuList | Returns a list of ItemDetails for the specified list of skus.
*ItemDetailsApi* | [**apiV1ItemDetailsGetItemDetailsGet**](docs/Api/ItemDetailsApi.md#apiv1itemdetailsgetitemdetailsget) | **GET** /api/v1/ItemDetails/GetItemDetails | Returns a list of ItemDetails modified since the supplied date
*ItemDetailsApi* | [**apiV2ItemDetailsGetItemDetailsByAttributeGet**](docs/Api/ItemDetailsApi.md#apiv2itemdetailsgetitemdetailsbyattributeget) | **GET** /api/v2/ItemDetails/GetItemDetailsByAttribute | Returns a list of ItemDetails that have the specified attribute code or description
*ItemDetailsApi* | [**apiV2ItemDetailsGetItemDetailsByIdListGet**](docs/Api/ItemDetailsApi.md#apiv2itemdetailsgetitemdetailsbyidlistget) | **GET** /api/v2/ItemDetails/GetItemDetailsByIdList | Returns a list of ItemDetails for the specified list of item master ids.
*ItemDetailsApi* | [**apiV2ItemDetailsGetItemDetailsBySkuGet**](docs/Api/ItemDetailsApi.md#apiv2itemdetailsgetitemdetailsbyskuget) | **GET** /api/v2/ItemDetails/GetItemDetailsBySku | Returns a single ItemDetails with the specified sku.
*ItemDetailsApi* | [**apiV2ItemDetailsGetItemDetailsBySkuListGet**](docs/Api/ItemDetailsApi.md#apiv2itemdetailsgetitemdetailsbyskulistget) | **GET** /api/v2/ItemDetails/GetItemDetailsBySkuList | Returns a list of ItemDetails for the specified list of skus.
*ItemDetailsApi* | [**apiV2ItemDetailsGetItemDetailsGet**](docs/Api/ItemDetailsApi.md#apiv2itemdetailsgetitemdetailsget) | **GET** /api/v2/ItemDetails/GetItemDetails | Returns a list of ItemDetails modified since the supplied date
*ItemDetailsApi* | [**apiV2ItemDetailsItemMasterIdGet**](docs/Api/ItemDetailsApi.md#apiv2itemdetailsitemmasteridget) | **GET** /api/v2/ItemDetails/{itemMasterId} | Returns a single ItemDetails with the specified item master id
*ItemDetailsApi* | [**getItemDetails**](docs/Api/ItemDetailsApi.md#getitemdetails) | **GET** /api/v1/ItemDetails/{itemMasterId} | Returns a single ItemDetails with the specified item master id
*ItemLocationDetailAttributesApi* | [**apiV1ItemLocationDetailAttributesGetItemLocationDetailsWithAttributesGet**](docs/Api/ItemLocationDetailAttributesApi.md#apiv1itemlocationdetailattributesgetitemlocationdetailswithattributesget) | **GET** /api/v1/ItemLocationDetailAttributes/GetItemLocationDetailsWithAttributes | Returns an array of ItemLocationDetails with attribute data that match the specified search criteria  The last updated date and location id are required parameters
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndItemMasterIdGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsgetitemlocationdetailbylocationidanditemmasteridget) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndItemMasterId | Returns a single ItemLocationDetail with the specified LocationId and ItemMasterId
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndProductCodeGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsgetitemlocationdetailbylocationidandproductcodeget) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndProductCode | Returns a single ItemLocationDetail with the specified LocationId and product code
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsGetItemLocationDetailByLocationIdAndSkuGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsgetitemlocationdetailbylocationidandskuget) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailByLocationIdAndSku | Returns a single ItemLocationDetail with the specified LocationId and sku
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsGetItemLocationDetailsByLocationIdAndSkuListGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsgetitemlocationdetailsbylocationidandskulistget) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailsByLocationIdAndSkuList | Returns a list ItemLocationDetails with the specified LocationId and skus
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsGetItemLocationDetailsGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsgetitemlocationdetailsget) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetails | Returns an array of ItemLocationDetails that match the specified search criteria  The last updated date and location id are required parameters
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsGetItemLocationDetailsModifiedSinceSpecifiedDateGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsgetitemlocationdetailsmodifiedsincespecifieddateget) | **GET** /api/v1/ItemLocationDetails/GetItemLocationDetailsModifiedSinceSpecifiedDate | Returns an array of ItemLocationDetails that have been modified since the specified date
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsItemLocationDetailIdItemQuestionsGet**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailsitemlocationdetailiditemquestionsget) | **GET** /api/v1/ItemLocationDetails/{itemLocationDetailId}/ItemQuestions | Returns an array of Questions associated with the specified ItemLocationDetail.
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsPatchMultipleItemLocationDetailsPatch**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailspatchmultipleitemlocationdetailspatch) | **PATCH** /api/v1/ItemLocationDetails/PatchMultipleItemLocationDetails | Updates specified properties of multiple ItemLocationDetails.
*ItemLocationDetailsApi* | [**apiV1ItemLocationDetailsPostMultipleItemLocationDetailsPost**](docs/Api/ItemLocationDetailsApi.md#apiv1itemlocationdetailspostmultipleitemlocationdetailspost) | **POST** /api/v1/ItemLocationDetails/PostMultipleItemLocationDetails | Creates multiple new item location details.
*ItemMasterAttributesApi* | [**apiV1ItemMasterAttributesGetItemMasterAttributeGroupsGet**](docs/Api/ItemMasterAttributesApi.md#apiv1itemmasterattributesgetitemmasterattributegroupsget) | **GET** /api/v1/ItemMasterAttributes/GetItemMasterAttributeGroups | Returns the list of item master attribute groups.
*ItemMasterAttributesApi* | [**apiV1ItemMasterAttributesGetItemMasterAttributesBySkuGet**](docs/Api/ItemMasterAttributesApi.md#apiv1itemmasterattributesgetitemmasterattributesbyskuget) | **GET** /api/v1/ItemMasterAttributes/GetItemMasterAttributesBySku | Returns a list of attributes for the ItemMaster with the specified sku.
*ItemMasterAttributesApi* | [**apiV1ItemMasterAttributesGetItemMastersWithAttributesByIdsGet**](docs/Api/ItemMasterAttributesApi.md#apiv1itemmasterattributesgetitemmasterswithattributesbyidsget) | **GET** /api/v1/ItemMasterAttributes/GetItemMastersWithAttributesByIds | Returns a list item masters with attributes for the ItemMaster with the specified ids.
*ItemMasterAttributesApi* | [**apiV1ItemMasterAttributesGetItemMastersWithAttributesBySkusGet**](docs/Api/ItemMasterAttributesApi.md#apiv1itemmasterattributesgetitemmasterswithattributesbyskusget) | **GET** /api/v1/ItemMasterAttributes/GetItemMastersWithAttributesBySkus | Returns a list item masters with attributes for the ItemMaster with the specified skus.
*ItemMasterAttributesApi* | [**getItemMasterAttributesById**](docs/Api/ItemMasterAttributesApi.md#getitemmasterattributesbyid) | **GET** /api/v1/ItemMasterAttributes/{itemMasterId} | Returns a list of attributes for the ItemMaster with the specified id.
*ItemMastersApi* | [**apiV1ItemMastersGet**](docs/Api/ItemMastersApi.md#apiv1itemmastersget) | **GET** /api/v1/ItemMasters | Returns an array of ItemMasters that match the specified search criteria.
*ItemMastersApi* | [**apiV1ItemMastersGetItemMasterBySkuGet**](docs/Api/ItemMastersApi.md#apiv1itemmastersgetitemmasterbyskuget) | **GET** /api/v1/ItemMasters/GetItemMasterBySku | Returns a single ItemMaster with the specified sku.
*ItemMastersApi* | [**apiV1ItemMastersPatchMultipleItemMastersPatch**](docs/Api/ItemMastersApi.md#apiv1itemmasterspatchmultipleitemmasterspatch) | **PATCH** /api/v1/ItemMasters/PatchMultipleItemMasters | Updates specified properties of multiple item masters.
*ItemMastersApi* | [**apiV1ItemMastersPost**](docs/Api/ItemMastersApi.md#apiv1itemmasterspost) | **POST** /api/v1/ItemMasters | Creates a new item master.
*ItemMastersApi* | [**apiV1ItemMastersPostMultipleItemMastersPost**](docs/Api/ItemMastersApi.md#apiv1itemmasterspostmultipleitemmasterspost) | **POST** /api/v1/ItemMasters/PostMultipleItemMasters | Creates multiple new item masters.
*ItemMastersApi* | [**getItemMasterById**](docs/Api/ItemMastersApi.md#getitemmasterbyid) | **GET** /api/v1/ItemMasters/{itemMasterId} | Returns a single ItemMaster with the specified id.
*ItemsApi* | [**apiV1ItemsGetItemByLocationIdAndProductCodeGet**](docs/Api/ItemsApi.md#apiv1itemsgetitembylocationidandproductcodeget) | **GET** /api/v1/Items/GetItemByLocationIdAndProductCode | Returns a single Item with the specified location id and product code.  Product code can be the item sku, barcode number, or any of an items&#39;s alias skus.
*ItemsApi* | [**apiV1ItemsItemLocationDetailIdItemQuestionsGet**](docs/Api/ItemsApi.md#apiv1itemsitemlocationdetailiditemquestionsget) | **GET** /api/v1/Items/{itemLocationDetailId}/ItemQuestions | Returns an array of Questions associated with the item with the specified itemLocationDetailId
*LocationGroupsApi* | [**apiV1LocationGroupsGet**](docs/Api/LocationGroupsApi.md#apiv1locationgroupsget) | **GET** /api/v1/LocationGroups | Returns an array of Location Groups.  NOTE: The result is cached for an hour after the first call. Changes made to  any location group in that time won&#39;t be returned by any calls to this  method within that hour.
*LocationsApi* | [**apiV1LocationsGet**](docs/Api/LocationsApi.md#apiv1locationsget) | **GET** /api/v1/Locations | Returns an array of Locations.  NOTE: The result is cached for an hour after the first call. Changes made to  any location in that time won&#39;t be returned by any calls to this  method within that hour.
*LocationsApi* | [**apiV1LocationsGetLocationByCodeGet**](docs/Api/LocationsApi.md#apiv1locationsgetlocationbycodeget) | **GET** /api/v1/Locations/GetLocationByCode | Returns a single Location with the specified code.  NOTE: The result is cached for an hour after the first call. Changes made to  any location in that time won&#39;t be returned by any calls to this  method within that hour.
*LoyaltyCardsApi* | [**apiV1LoyaltyCardsCreateLoyaltyCardPost**](docs/Api/LoyaltyCardsApi.md#apiv1loyaltycardscreateloyaltycardpost) | **POST** /api/v1/LoyaltyCards/CreateLoyaltyCard | Creates a loyalty card
*LoyaltyCardsApi* | [**apiV1LoyaltyCardsGetLoyaltyCardByNumberGet**](docs/Api/LoyaltyCardsApi.md#apiv1loyaltycardsgetloyaltycardbynumberget) | **GET** /api/v1/LoyaltyCards/GetLoyaltyCardByNumber | Returns a single LoyaltyCard with the specified number.
*LoyaltyCardsApi* | [**apiV1LoyaltyCardsLoyaltyCardIdPatch**](docs/Api/LoyaltyCardsApi.md#apiv1loyaltycardsloyaltycardidpatch) | **PATCH** /api/v1/LoyaltyCards/{loyaltyCardId} | Updates specified properties of a loyalty card.
*LoyaltyCardsApi* | [**getLoyaltyCardById**](docs/Api/LoyaltyCardsApi.md#getloyaltycardbyid) | **GET** /api/v1/LoyaltyCards/{loyaltyCardId} | Returns a single LoyaltyCard with the specified id.
*LoyaltyPointsBulkUpdateApi* | [**apiV1LoyaltyPointsBulkUpdatesPost**](docs/Api/LoyaltyPointsBulkUpdateApi.md#apiv1loyaltypointsbulkupdatespost) | **POST** /api/v1/LoyaltyPointsBulkUpdates | Creates a new set of loyalty points.
*LoyaltyTypesApi* | [**apiV1LoyaltyTypesGet**](docs/Api/LoyaltyTypesApi.md#apiv1loyaltytypesget) | **GET** /api/v1/LoyaltyTypes | Returns an array of Loyalty Types that match the specified search criteria.
*MailerLogBulkUpdateApi* | [**apiV1MailerLogBulkUpdatesPost**](docs/Api/MailerLogBulkUpdateApi.md#apiv1mailerlogbulkupdatespost) | **POST** /api/v1/MailerLogBulkUpdates | Updates the mailer status of a collection of customers.
*ManualAdjustmentsApi* | [**apiV1ManualAdjustmentsGet**](docs/Api/ManualAdjustmentsApi.md#apiv1manualadjustmentsget) | **GET** /api/v1/ManualAdjustments | Returns an array of ManualAdjustments.
*MatrixMastersApi* | [**apiV1MatrixMastersGet**](docs/Api/MatrixMastersApi.md#apiv1matrixmastersget) | **GET** /api/v1/MatrixMasters | Returns an array of Matrix Masters for a given location
*MatrixMastersApi* | [**apiV1MatrixMastersGetMatrixMasterBySkuGet**](docs/Api/MatrixMastersApi.md#apiv1matrixmastersgetmatrixmasterbyskuget) | **GET** /api/v1/MatrixMasters/GetMatrixMasterBySku | Returns a single MatrixMaster with the specified sku.
*MatrixMastersApi* | [**getMatrixMasterById**](docs/Api/MatrixMastersApi.md#getmatrixmasterbyid) | **GET** /api/v1/MatrixMasters/{matrixMasterId} | Returns a single MatrixMaster with the specified id.
*OrderDetailsApi* | [**apiV1OrderDetailsDispatchOrderPost**](docs/Api/OrderDetailsApi.md#apiv1orderdetailsdispatchorderpost) | **POST** /api/v1/OrderDetails/DispatchOrder | Dispatch a customer order.
*OrderDetailsApi* | [**apiV1OrderDetailsGetOrderDetailsGet**](docs/Api/OrderDetailsApi.md#apiv1orderdetailsgetorderdetailsget) | **GET** /api/v1/OrderDetails/GetOrderDetails | Returns an array of OrderDetails that match the specified search criteria.
*OrderDetailsApi* | [**getOrderDetailsById**](docs/Api/OrderDetailsApi.md#getorderdetailsbyid) | **GET** /api/v1/OrderDetails/{orderId} | Returns a OrderDetails for a given inventory control document id.
*PersonTitlesApi* | [**apiV1PersonTitlesGet**](docs/Api/PersonTitlesApi.md#apiv1persontitlesget) | **GET** /api/v1/PersonTitles | Returns an array of Person Titles.
*PromotionCalculationsApi* | [**apiV1PromotionCalculationsControllerReloadPromotionsPost**](docs/Api/PromotionCalculationsApi.md#apiv1promotioncalculationscontrollerreloadpromotionspost) | **POST** /api/v1/PromotionCalculationsController/ReloadPromotions | Reloads promotions.
*PromotionHeadersApi* | [**apiV1PromotionHeadersGet**](docs/Api/PromotionHeadersApi.md#apiv1promotionheadersget) | **GET** /api/v1/PromotionHeaders | Returns an array of Promotion Headers that match the specified search criteria.
*PromotionHeadersApi* | [**apiV1PromotionHeadersGetPromotionHeadersForItemGet**](docs/Api/PromotionHeadersApi.md#apiv1promotionheadersgetpromotionheadersforitemget) | **GET** /api/v1/PromotionHeaders/GetPromotionHeadersForItem | Returns an array of Promotion Headers that could fire for the supplied item.
*PromotionHeadersApi* | [**apiV1PromotionHeadersGetPromotionHeadersForItemsGet**](docs/Api/PromotionHeadersApi.md#apiv1promotionheadersgetpromotionheadersforitemsget) | **GET** /api/v1/PromotionHeaders/GetPromotionHeadersForItems | Returns an array of Promotion Headers that could fire for the supplied item.
*PromotionHeadersApi* | [**getPromotionHeaderById**](docs/Api/PromotionHeadersApi.md#getpromotionheaderbyid) | **GET** /api/v1/PromotionHeaders/{promotionId} | Returns a single PromotionHeader with the specified id.
*PromotionItemsApi* | [**apiV1PromotionItemsGet**](docs/Api/PromotionItemsApi.md#apiv1promotionitemsget) | **GET** /api/v1/PromotionItems | Returns an array of Promotion Items that match the specified search criteria.
*PurchaseOrdersApi* | [**apiV1PurchaseOrderGetPurchaseOrderByOrderNumberGet**](docs/Api/PurchaseOrdersApi.md#apiv1purchaseordergetpurchaseorderbyordernumberget) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrderByOrderNumber | Returns a PurchaseOrder for a given inventory control document order number.
*PurchaseOrdersApi* | [**apiV1PurchaseOrderGetPurchaseOrderGet**](docs/Api/PurchaseOrdersApi.md#apiv1purchaseordergetpurchaseorderget) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrder | Returns an array of PurchaseOrder that match the specified search criteria.
*PurchaseOrdersApi* | [**apiV1PurchaseOrderGetPurchaseOrderLinesByIdGet**](docs/Api/PurchaseOrdersApi.md#apiv1purchaseordergetpurchaseorderlinesbyidget) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrderLinesById | Returns the lines on a Purchase Order.
*PurchaseOrdersApi* | [**apiV1PurchaseOrderGetPurchaseOrderLinesByOrderNumberGet**](docs/Api/PurchaseOrdersApi.md#apiv1purchaseordergetpurchaseorderlinesbyordernumberget) | **GET** /api/v1/PurchaseOrder/GetPurchaseOrderLinesByOrderNumber | Returns the lines on a Purchase Order.
*PurchaseOrdersApi* | [**getPurchaseOrderById**](docs/Api/PurchaseOrdersApi.md#getpurchaseorderbyid) | **GET** /api/v1/PurchaseOrder/{inventoryControlDocumentId} | Returns a PurchaseOrder for a given inventory control document id.
*ReasonCodesApi* | [**apiV1ReasonCodesGet**](docs/Api/ReasonCodesApi.md#apiv1reasoncodesget) | **GET** /api/v1/ReasonCodes | Returns an array of Reason Codes that match the specified search criteria.
*ReasonCodesApi* | [**getReasonCodeById**](docs/Api/ReasonCodesApi.md#getreasoncodebyid) | **GET** /api/v1/ReasonCodes/{reasonCodeId} | Returns a single ReasonCode with the specified id.
*RegistersApi* | [**apiV1RegistersGet**](docs/Api/RegistersApi.md#apiv1registersget) | **GET** /api/v1/Registers | Returns an array of Registers that match the specified search criteria.
*RegistersApi* | [**apiV1RegistersGetRegisterByNumberAndLocationIdGet**](docs/Api/RegistersApi.md#apiv1registersgetregisterbynumberandlocationidget) | **GET** /api/v1/Registers/GetRegisterByNumberAndLocationId | Returns a single Register with the specified number at the specified location.
*RegistersApi* | [**getRegisterById**](docs/Api/RegistersApi.md#getregisterbyid) | **GET** /api/v1/Registers/{registerId} | Returns a single Register with the specified id.
*SalesOrdersApi* | [**apiV1SalesOrdersGet**](docs/Api/SalesOrdersApi.md#apiv1salesordersget) | **GET** /api/v1/SalesOrders | Returns an array of SalesOrders that match the specified search criteria.
*SalesOrdersApi* | [**apiV1SalesOrdersOrderIdClosedStatusGet**](docs/Api/SalesOrdersApi.md#apiv1salesordersorderidclosedstatusget) | **GET** /api/v1/SalesOrders/{orderId}/ClosedStatus | Returns the closed status for the specified sales order.
*SalesOrdersApi* | [**apiV1SalesOrdersUpdateTrackingNumberPatch**](docs/Api/SalesOrdersApi.md#apiv1salesordersupdatetrackingnumberpatch) | **PATCH** /api/v1/SalesOrders/UpdateTrackingNumber | Updates the shipping tracking number on the specified order
*SalesOrdersApi* | [**apiV2SalesOrdersGet**](docs/Api/SalesOrdersApi.md#apiv2salesordersget) | **GET** /api/v2/SalesOrders | Returns an array of SalesOrders that match the specified search criteria.
*SalesOrdersApi* | [**createMultiLocationSalesOrderFromBasket**](docs/Api/SalesOrdersApi.md#createmultilocationsalesorderfrombasket) | **POST** /api/v1/SalesOrders/CreateMultiLocationSalesOrderFromBasket | Creates a new sales order from a stored basket of goods,  converts the sales order to a retail transaction,  and creates a picking order for the specified stock location
*SalesOrdersApi* | [**createSalesOrderFromBasket**](docs/Api/SalesOrdersApi.md#createsalesorderfrombasket) | **POST** /api/v1/SalesOrders/CreateSalesOrderFromBasket | Creates a new sales order from a stored basket of goods.
*SalesOrdersApi* | [**getSalesOrderByOrderId**](docs/Api/SalesOrdersApi.md#getsalesorderbyorderid) | **GET** /api/v1/SalesOrders/{orderId} | Returns the specified sales order transaction.
*SalesRepsApi* | [**apiV1SalesRepsGet**](docs/Api/SalesRepsApi.md#apiv1salesrepsget) | **GET** /api/v1/SalesReps | Returns an array of SalesReps that match the specified search criteria.
*ShippingCarriersApi* | [**apiV1ShippingCarriersGet**](docs/Api/ShippingCarriersApi.md#apiv1shippingcarriersget) | **GET** /api/v1/ShippingCarriers | Returns an array of Suppliers that match the specified search criteria.
*SimpleTaxRatesApi* | [**apiV1SimpleTaxRatesGet**](docs/Api/SimpleTaxRatesApi.md#apiv1simpletaxratesget) | **GET** /api/v1/SimpleTaxRates | Returns an array of SimpleTaxRates.
*SimpleTaxRatesApi* | [**apiV1SimpleTaxRatesGetSimpleTaxRateByCodeGet**](docs/Api/SimpleTaxRatesApi.md#apiv1simpletaxratesgetsimpletaxratebycodeget) | **GET** /api/v1/SimpleTaxRates/GetSimpleTaxRateByCode | Returns a single SimpleTaxRate with the specified code.
*SimpleTaxRatesApi* | [**apiV1SimpleTaxRatesIdPatch**](docs/Api/SimpleTaxRatesApi.md#apiv1simpletaxratesidpatch) | **PATCH** /api/v1/SimpleTaxRates/{id} | Updates specified properties of a simple tax rate.
*SimpleTaxRatesApi* | [**apiV1SimpleTaxRatesPost**](docs/Api/SimpleTaxRatesApi.md#apiv1simpletaxratespost) | **POST** /api/v1/SimpleTaxRates | Creates a new simple tax rate.
*SimpleTaxRatesApi* | [**getSimpleTaxRateById**](docs/Api/SimpleTaxRatesApi.md#getsimpletaxratebyid) | **GET** /api/v1/SimpleTaxRates/{id} | Returns a single SimpleTaxRate with the specified id.
*SupplierItemsApi* | [**apiV1SupplierItemsGetSupplierItemBySupplierIdAndItemMasterIdGet**](docs/Api/SupplierItemsApi.md#apiv1supplieritemsgetsupplieritembysupplieridanditemmasteridget) | **GET** /api/v1/SupplierItems/GetSupplierItemBySupplierIdAndItemMasterId | Returns a single SupplierItem with the specified supplierId and itemMasterId.
*SupplierItemsApi* | [**apiV1SupplierItemsPatchMultipleSupplierItemsPatch**](docs/Api/SupplierItemsApi.md#apiv1supplieritemspatchmultiplesupplieritemspatch) | **PATCH** /api/v1/SupplierItems/PatchMultipleSupplierItems | Updates specified properties of multiple SupplierItems.
*SupplierItemsApi* | [**apiV1SupplierItemsPostMultipleSupplierItemsPost**](docs/Api/SupplierItemsApi.md#apiv1supplieritemspostmultiplesupplieritemspost) | **POST** /api/v1/SupplierItems/PostMultipleSupplierItems | Creates multiple new SupplierItems.
*SupplierItemsApi* | [**apiV1SupplierItemsSupplierItemIdDelete**](docs/Api/SupplierItemsApi.md#apiv1supplieritemssupplieritemiddelete) | **DELETE** /api/v1/SupplierItems/{supplierItemId} | Deletes a single SupplierItem by reference to id.
*SuppliersApi* | [**apiV1SuppliersGet**](docs/Api/SuppliersApi.md#apiv1suppliersget) | **GET** /api/v1/Suppliers | Returns an array of Suppliers that match the specified search criteria.
*SuppliersApi* | [**apiV1SuppliersGetSupplierByCodeGet**](docs/Api/SuppliersApi.md#apiv1suppliersgetsupplierbycodeget) | **GET** /api/v1/Suppliers/GetSupplierByCode | Returns a single Supplier with the specified code.
*SuppliersApi* | [**apiV1SuppliersPost**](docs/Api/SuppliersApi.md#apiv1supplierspost) | **POST** /api/v1/Suppliers | Creates a new supplier.
*SuppliersApi* | [**getSupplierById**](docs/Api/SuppliersApi.md#getsupplierbyid) | **GET** /api/v1/Suppliers/{supplierId} | Returns a single Supplier with the specified id.
*TenderDefinitionsApi* | [**apiV1TenderDefinitionsGetTenderDefinitionByCodeAndLocationIdGet**](docs/Api/TenderDefinitionsApi.md#apiv1tenderdefinitionsgettenderdefinitionbycodeandlocationidget) | **GET** /api/v1/TenderDefinitions/GetTenderDefinitionByCodeAndLocationId | Returns a single TenderDefinition with the specified code and location id.
*TenderDefinitionsApi* | [**apiV1TenderDefinitionsGetTenderDefinitionsByLocationIdGet**](docs/Api/TenderDefinitionsApi.md#apiv1tenderdefinitionsgettenderdefinitionsbylocationidget) | **GET** /api/v1/TenderDefinitions/GetTenderDefinitionsByLocationId | Returns an array of TenderDefinitions that match the specified search criteria.
*TenderDefinitionsApi* | [**getTenderDefinitionById**](docs/Api/TenderDefinitionsApi.md#gettenderdefinitionbyid) | **GET** /api/v1/TenderDefinitions/{tenderDefinitionId} | Returns a single TenderDefinition with the specified id.
*TenderTypesApi* | [**apiV1TenderTypesGet**](docs/Api/TenderTypesApi.md#apiv1tendertypesget) | **GET** /api/v1/TenderTypes | Returns an array of TenderTypes.
*TokenApi* | [**tokenPost**](docs/Api/TokenApi.md#tokenpost) | **POST** /token | 
*TransactionHeadersApi* | [**apiV1TransactionHeadersGet**](docs/Api/TransactionHeadersApi.md#apiv1transactionheadersget) | **GET** /api/v1/TransactionHeaders | Returns an array of TransactionHeaders that match the specified search criteria.
*TransactionHeadersApi* | [**apiV1TransactionHeadersTransactionIdLinesGet**](docs/Api/TransactionHeadersApi.md#apiv1transactionheaderstransactionidlinesget) | **GET** /api/v1/TransactionHeaders/{transactionId}/Lines | Returns an array of transaction lines for the specified transaction header.
*TransactionStatusesApi* | [**apiV1TransactionStatusesGet**](docs/Api/TransactionStatusesApi.md#apiv1transactionstatusesget) | **GET** /api/v1/TransactionStatuses | Retrieves an array of TransactionStatuses, subject to the search parameters.
*TransactionsApi* | [**apiV1TransactionsGetTransactionsGet**](docs/Api/TransactionsApi.md#apiv1transactionsgettransactionsget) | **GET** /api/v1/Transactions/GetTransactions | Returns an array of Transactions based on the supplied search criteria.
*TransactionsApi* | [**apiV1TransactionsGetTransactionsWithIdGreaterThanSpecifiedIdGet**](docs/Api/TransactionsApi.md#apiv1transactionsgettransactionswithidgreaterthanspecifiedidget) | **GET** /api/v1/Transactions/GetTransactionsWithIdGreaterThanSpecifiedId | Returns an array of Transactions with an id greater than the specified id.
*TransactionsApi* | [**apiV1TransactionsPost**](docs/Api/TransactionsApi.md#apiv1transactionspost) | **POST** /api/v1/Transactions | Creates a new transaction.
*TransactionsApi* | [**apiV1TransactionsRefundTransactionPost**](docs/Api/TransactionsApi.md#apiv1transactionsrefundtransactionpost) | **POST** /api/v1/Transactions/RefundTransaction | Refunds a transaction.
*TransactionsApi* | [**apiV2TransactionsGetTransactionsGet**](docs/Api/TransactionsApi.md#apiv2transactionsgettransactionsget) | **GET** /api/v2/Transactions/GetTransactions | Returns an array of Transactions based on the supplied search criteria.
*TransactionsApi* | [**getTransactionById**](docs/Api/TransactionsApi.md#gettransactionbyid) | **GET** /api/v1/Transactions/{transactionId} | Returns a single Transaction with the specified id.
*TransferDetailsApi* | [**apiV1TransferDetailsGetTransferDetailsByOrderNumberGet**](docs/Api/TransferDetailsApi.md#apiv1transferdetailsgettransferdetailsbyordernumberget) | **GET** /api/v1/TransferDetails/GetTransferDetailsByOrderNumber | Returns a TransferDetails for a given inventory control document order number.
*TransferDetailsApi* | [**apiV1TransferDetailsGetTransferDetailsGet**](docs/Api/TransferDetailsApi.md#apiv1transferdetailsgettransferdetailsget) | **GET** /api/v1/TransferDetails/GetTransferDetails | Returns an array of TransferDetails that match the specified search criteria.
*TransferDetailsApi* | [**apiV1TransferDetailsIssueTransferPost**](docs/Api/TransferDetailsApi.md#apiv1transferdetailsissuetransferpost) | **POST** /api/v1/TransferDetails/IssueTransfer | Issues a transfer
*TransferDetailsApi* | [**getTransferDetailsById**](docs/Api/TransferDetailsApi.md#gettransferdetailsbyid) | **GET** /api/v1/TransferDetails/{inventoryControlDocumentId} | Returns a TransferDetails for a given inventory control document id.
*UnitsOfMeasureApi* | [**apiV1UnitsOfMeasureDefaultUomIdGet**](docs/Api/UnitsOfMeasureApi.md#apiv1unitsofmeasuredefaultuomidget) | **GET** /api/v1/UnitsOfMeasure/DefaultUomId | Returns an integer which is the id of the default unit of measure.
*UnitsOfMeasureApi* | [**apiV1UnitsOfMeasureGetUnitOfMeasureByCodeGet**](docs/Api/UnitsOfMeasureApi.md#apiv1unitsofmeasuregetunitofmeasurebycodeget) | **GET** /api/v1/UnitsOfMeasure/GetUnitOfMeasureByCode | Returns a single UnitOfMeasure with the specified code.
*UnitsOfMeasureApi* | [**apiV1UnitsOfMeasureGetUomsByDescriptionGet**](docs/Api/UnitsOfMeasureApi.md#apiv1unitsofmeasuregetuomsbydescriptionget) | **GET** /api/v1/UnitsOfMeasure/GetUomsByDescription | Returns an array of UnitOfMeasure with the specified description.
*UnitsOfMeasureApi* | [**apiV1UnitsOfMeasurePost**](docs/Api/UnitsOfMeasureApi.md#apiv1unitsofmeasurepost) | **POST** /api/v1/UnitsOfMeasure | Creates a new UnitOfMeasure.
*UnitsOfMeasureApi* | [**apiV1UnitsOfMeasureUnitOfMeasureIdPatch**](docs/Api/UnitsOfMeasureApi.md#apiv1unitsofmeasureunitofmeasureidpatch) | **PATCH** /api/v1/UnitsOfMeasure/{unitOfMeasureId} | Updates specified properties of a UnitOfMeasure.
*UnitsOfMeasureApi* | [**getUnitOfMeasureById**](docs/Api/UnitsOfMeasureApi.md#getunitofmeasurebyid) | **GET** /api/v1/UnitsOfMeasure/{unitOfMeasureId} | Returns a single UnitOfMeasure with the specified id.
*VouchersApi* | [**apiV1VouchersGet**](docs/Api/VouchersApi.md#apiv1vouchersget) | **GET** /api/v1/Vouchers | Returns an array of Vouchers that match the specified search criteria.
*VouchersApi* | [**apiV1VouchersPatchMultipleVouchersPatch**](docs/Api/VouchersApi.md#apiv1voucherspatchmultiplevoucherspatch) | **PATCH** /api/v1/Vouchers/PatchMultipleVouchers | Updates specified properties of multiple vouchers.
*VouchersApi* | [**apiV1VouchersPost**](docs/Api/VouchersApi.md#apiv1voucherspost) | **POST** /api/v1/Vouchers | Creates a new voucher.
*VouchersApi* | [**apiV1VouchersPostMultipleVouchersPost**](docs/Api/VouchersApi.md#apiv1voucherspostmultiplevoucherspost) | **POST** /api/v1/Vouchers/PostMultipleVouchers | Creates multiple new vouchers.
*VouchersApi* | [**apiV1VouchersPostVoucherNumbersPost**](docs/Api/VouchersApi.md#apiv1voucherspostvouchernumberspost) | **POST** /api/v1/Vouchers/PostVoucherNumbers | Creates the specified number of new vouchers.
*VouchersApi* | [**apiV1VouchersPostVouchersPost**](docs/Api/VouchersApi.md#apiv1voucherspostvoucherspost) | **POST** /api/v1/Vouchers/PostVouchers | Creates the specified number of new vouchers.
*VouchersApi* | [**apiV1VouchersVoucherIdPatch**](docs/Api/VouchersApi.md#apiv1vouchersvoucheridpatch) | **PATCH** /api/v1/Vouchers/{voucherId} | Updates specified properties of a voucher.
*VouchersApi* | [**getVoucherById**](docs/Api/VouchersApi.md#getvoucherbyid) | **GET** /api/v1/Vouchers/{voucherId} | Returns a single Voucher with the specified id.
*VouchersApi* | [**getVoucherByNumber**](docs/Api/VouchersApi.md#getvoucherbynumber) | **GET** /api/v1/Vouchers/GetVoucherByNumber | Returns a single Voucher with the specified number.

## Models

- [AccountReceivable](docs/Model/AccountReceivable.md)
- [AccountReceivableBalance](docs/Model/AccountReceivableBalance.md)
- [AccountType](docs/Model/AccountType.md)
- [AttributeGroupItemMasterAttribute](docs/Model/AttributeGroupItemMasterAttribute.md)
- [Basket](docs/Model/Basket.md)
- [BasketLine](docs/Model/BasketLine.md)
- [Cashier](docs/Model/Cashier.md)
- [Category](docs/Model/Category.md)
- [Community](docs/Model/Community.md)
- [CommunityMember](docs/Model/CommunityMember.md)
- [Customer](docs/Model/Customer.md)
- [CustomerContact](docs/Model/CustomerContact.md)
- [CustomerDiscountCoupon](docs/Model/CustomerDiscountCoupon.md)
- [CustomerDiscountCouponDescription](docs/Model/CustomerDiscountCouponDescription.md)
- [CustomerLoyaltyField](docs/Model/CustomerLoyaltyField.md)
- [CustomerLoyaltyFieldConfig](docs/Model/CustomerLoyaltyFieldConfig.md)
- [CustomerLoyaltyFieldType](docs/Model/CustomerLoyaltyFieldType.md)
- [CustomerLoyaltyFieldsBulkUpdate](docs/Model/CustomerLoyaltyFieldsBulkUpdate.md)
- [CustomerPromotionCoupon](docs/Model/CustomerPromotionCoupon.md)
- [CustomerPromotionCouponDescription](docs/Model/CustomerPromotionCouponDescription.md)
- [CustomerRewardsCampaign](docs/Model/CustomerRewardsCampaign.md)
- [Department](docs/Model/Department.md)
- [GRNDetails](docs/Model/GRNDetails.md)
- [GRNSummary](docs/Model/GRNSummary.md)
- [HospitalityRoom](docs/Model/HospitalityRoom.md)
- [HospitalityTable](docs/Model/HospitalityTable.md)
- [InvoiceMatching](docs/Model/InvoiceMatching.md)
- [InvoiceMatchingLine](docs/Model/InvoiceMatchingLine.md)
- [InvoiceStatusTypeEnum](docs/Model/InvoiceStatusTypeEnum.md)
- [InvoiceTypeEnum](docs/Model/InvoiceTypeEnum.md)
- [IsoCountry](docs/Model/IsoCountry.md)
- [Item](docs/Model/Item.md)
- [ItemAlias](docs/Model/ItemAlias.md)
- [ItemBinLocation](docs/Model/ItemBinLocation.md)
- [ItemBinQuantities](docs/Model/ItemBinQuantities.md)
- [ItemBinQuantitiesUpdate](docs/Model/ItemBinQuantitiesUpdate.md)
- [ItemBinQuantitiesUpdateByName](docs/Model/ItemBinQuantitiesUpdateByName.md)
- [ItemDetails](docs/Model/ItemDetails.md)
- [ItemLocationDetail](docs/Model/ItemLocationDetail.md)
- [ItemLocationDetails](docs/Model/ItemLocationDetails.md)
- [ItemLocationQuantities](docs/Model/ItemLocationQuantities.md)
- [ItemMaster](docs/Model/ItemMaster.md)
- [ItemMasterAttribute](docs/Model/ItemMasterAttribute.md)
- [ItemMasterAttributeGroup](docs/Model/ItemMasterAttributeGroup.md)
- [ItemMasterWithAttributes](docs/Model/ItemMasterWithAttributes.md)
- [ItemMessage](docs/Model/ItemMessage.md)
- [ItemQuestion](docs/Model/ItemQuestion.md)
- [ItemQuestionChoice](docs/Model/ItemQuestionChoice.md)
- [KitComponent](docs/Model/KitComponent.md)
- [Location](docs/Model/Location.md)
- [LocationGroup](docs/Model/LocationGroup.md)
- [LoyaltyBalance](docs/Model/LoyaltyBalance.md)
- [LoyaltyCard](docs/Model/LoyaltyCard.md)
- [LoyaltyPointsBulkUpdate](docs/Model/LoyaltyPointsBulkUpdate.md)
- [LoyaltyTransaction](docs/Model/LoyaltyTransaction.md)
- [LoyaltyType](docs/Model/LoyaltyType.md)
- [MailerLogBulkUpdate](docs/Model/MailerLogBulkUpdate.md)
- [ManualAdjustment](docs/Model/ManualAdjustment.md)
- [MatrixItem](docs/Model/MatrixItem.md)
- [MatrixMaster](docs/Model/MatrixMaster.md)
- [MultiLocationSalesOrderBasket](docs/Model/MultiLocationSalesOrderBasket.md)
- [NumericSearchOperatorEnum](docs/Model/NumericSearchOperatorEnum.md)
- [OrderClosedStatus](docs/Model/OrderClosedStatus.md)
- [OrderDetails](docs/Model/OrderDetails.md)
- [OrderDetailsLine](docs/Model/OrderDetailsLine.md)
- [OrderDetailsLineUpdate](docs/Model/OrderDetailsLineUpdate.md)
- [OrderDetailsUpdate](docs/Model/OrderDetailsUpdate.md)
- [OrderRefundTransaction](docs/Model/OrderRefundTransaction.md)
- [OrderSalesTransaction](docs/Model/OrderSalesTransaction.md)
- [OrderTenderLine](docs/Model/OrderTenderLine.md)
- [OrderTransaction](docs/Model/OrderTransaction.md)
- [Patch](docs/Model/Patch.md)
- [PatchCollection](docs/Model/PatchCollection.md)
- [PatchResponse](docs/Model/PatchResponse.md)
- [PersonTitle](docs/Model/PersonTitle.md)
- [PostResponseCategory](docs/Model/PostResponseCategory.md)
- [PostResponseDepartment](docs/Model/PostResponseDepartment.md)
- [PostResponseItemAlias](docs/Model/PostResponseItemAlias.md)
- [PostResponseItemLocationDetail](docs/Model/PostResponseItemLocationDetail.md)
- [PostResponseItemMaster](docs/Model/PostResponseItemMaster.md)
- [PostResponseSupplierItem](docs/Model/PostResponseSupplierItem.md)
- [PostResponseVoucher](docs/Model/PostResponseVoucher.md)
- [PostResponseVouchers](docs/Model/PostResponseVouchers.md)
- [ProcessedBasket](docs/Model/ProcessedBasket.md)
- [ProcessedBasketBenefit](docs/Model/ProcessedBasketBenefit.md)
- [ProcessedBasketCoupon](docs/Model/ProcessedBasketCoupon.md)
- [ProcessedBasketLine](docs/Model/ProcessedBasketLine.md)
- [ProcessedBasketLineBenefit](docs/Model/ProcessedBasketLineBenefit.md)
- [PromotionHeader](docs/Model/PromotionHeader.md)
- [PromotionHeadersByItem](docs/Model/PromotionHeadersByItem.md)
- [PromotionItem](docs/Model/PromotionItem.md)
- [PurchaseOrder](docs/Model/PurchaseOrder.md)
- [ReasonCode](docs/Model/ReasonCode.md)
- [ReceivingDocumentTypeEnum](docs/Model/ReceivingDocumentTypeEnum.md)
- [RefundTransaction](docs/Model/RefundTransaction.md)
- [RefundTransactionLine](docs/Model/RefundTransactionLine.md)
- [Register](docs/Model/Register.md)
- [RetailTransaction](docs/Model/RetailTransaction.md)
- [SalesOrderBasket](docs/Model/SalesOrderBasket.md)
- [SalesRep](docs/Model/SalesRep.md)
- [SearchOperatorEnum](docs/Model/SearchOperatorEnum.md)
- [ShippingCarrier](docs/Model/ShippingCarrier.md)
- [ShippingService](docs/Model/ShippingService.md)
- [SimpleSearchOperatorEnum](docs/Model/SimpleSearchOperatorEnum.md)
- [SimpleTaxRate](docs/Model/SimpleTaxRate.md)
- [StringSearchOperatorEnum](docs/Model/StringSearchOperatorEnum.md)
- [Supplier](docs/Model/Supplier.md)
- [SupplierItem](docs/Model/SupplierItem.md)
- [TenderDefinition](docs/Model/TenderDefinition.md)
- [TenderLine](docs/Model/TenderLine.md)
- [TenderType](docs/Model/TenderType.md)
- [TransactionBenefit](docs/Model/TransactionBenefit.md)
- [TransactionHeader](docs/Model/TransactionHeader.md)
- [TransactionLine](docs/Model/TransactionLine.md)
- [TransactionLineBenefit](docs/Model/TransactionLineBenefit.md)
- [TransactionStatus](docs/Model/TransactionStatus.md)
- [TransferDetails](docs/Model/TransferDetails.md)
- [TransferDetailsLine](docs/Model/TransferDetailsLine.md)
- [TransferDetailsLineUpdate](docs/Model/TransferDetailsLineUpdate.md)
- [TransferDetailsUpdate](docs/Model/TransferDetailsUpdate.md)
- [UnitOfMeasure](docs/Model/UnitOfMeasure.md)
- [Voucher](docs/Model/Voucher.md)
- [WebContent](docs/Model/WebContent.md)
- [WebLink](docs/Model/WebLink.md)

## Authorization

Authentication schemes defined for the API:
### bearer

- **Type**: Bearer authentication (JWT)

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

opsuitesupport@davrich.co.uk

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `v2`
    - Package version: `1.0`
    - Generator version: `7.13.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
