<?php

namespace Opsuite\Voucher;

use Opsuite\WSSSoapClient;

class VoucherService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfGiftCardEntry' => 'Opsuite\\Voucher\\ArrayOfGiftCardEntry',
      'GiftCardEntry' => 'Opsuite\\Voucher\\GiftCardEntry',
      'GiftCard' => 'Opsuite\\Voucher\\GiftCard',
      'GetGiftCardBalance' => 'Opsuite\\Voucher\\GetGiftCardBalance',
      'GetGiftCardBalanceResponse' => 'Opsuite\\Voucher\\GetGiftCardBalanceResponse',
      'HasGiftCardExpired' => 'Opsuite\\Voucher\\HasGiftCardExpired',
      'HasGiftCardExpiredResponse' => 'Opsuite\\Voucher\\HasGiftCardExpiredResponse',
      'GetGiftCardExpiryDate' => 'Opsuite\\Voucher\\GetGiftCardExpiryDate',
      'GetGiftCardExpiryDateResponse' => 'Opsuite\\Voucher\\GetGiftCardExpiryDateResponse',
      'GetGiftCardHistory' => 'Opsuite\\Voucher\\GetGiftCardHistory',
      'GetGiftCardHistoryResponse' => 'Opsuite\\Voucher\\GetGiftCardHistoryResponse',
      'GetGiftCardDetails' => 'Opsuite\\Voucher\\GetGiftCardDetails',
      'GetGiftCardDetailsResponse' => 'Opsuite\\Voucher\\GetGiftCardDetailsResponse',
      'GenerateGiftCardNumber' => 'Opsuite\\Voucher\\GenerateGiftCardNumber',
      'GenerateGiftCardNumberResponse' => 'Opsuite\\Voucher\\GenerateGiftCardNumberResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/VoucherService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetGiftCardBalance $parameters
     * @return GetGiftCardBalanceResponse
     */
    public function GetGiftCardBalance(GetGiftCardBalance $parameters)
    {
      return $this->__soapCall('GetGiftCardBalance', array($parameters));
    }

    /**
     * @param HasGiftCardExpired $parameters
     * @return HasGiftCardExpiredResponse
     */
    public function HasGiftCardExpired(HasGiftCardExpired $parameters)
    {
      return $this->__soapCall('HasGiftCardExpired', array($parameters));
    }

    /**
     * @param GetGiftCardExpiryDate $parameters
     * @return GetGiftCardExpiryDateResponse
     */
    public function GetGiftCardExpiryDate(GetGiftCardExpiryDate $parameters)
    {
      return $this->__soapCall('GetGiftCardExpiryDate', array($parameters));
    }

    /**
     * @param GetGiftCardHistory $parameters
     * @return GetGiftCardHistoryResponse
     */
    public function GetGiftCardHistory(GetGiftCardHistory $parameters)
    {
      return $this->__soapCall('GetGiftCardHistory', array($parameters));
    }

    /**
     * @param GetGiftCardDetails $parameters
     * @return GetGiftCardDetailsResponse
     */
    public function GetGiftCardDetails(GetGiftCardDetails $parameters)
    {
      return $this->__soapCall('GetGiftCardDetails', array($parameters));
    }

    /**
     * @param GenerateGiftCardNumber $parameters
     * @return GenerateGiftCardNumberResponse
     */
    public function GenerateGiftCardNumber(GenerateGiftCardNumber $parameters)
    {
      return $this->__soapCall('GenerateGiftCardNumber', array($parameters));
    }

}
