<?php

namespace Opsuite\Voucher;

class GiftCardEntry
{

    /**
     * @var float $Amount
     */
    protected $Amount = null;

    /**
     * @var GiftCardEntryType $EntryType
     */
    protected $EntryType = null;

    /**
     * @var int $ExternalTransactionNumber
     */
    protected $ExternalTransactionNumber = null;

    /**
     * @var int $ExternalVoucherEntryId
     */
    protected $ExternalVoucherEntryId = null;

    /**
     * @var string $LocationCode
     */
    protected $LocationCode = null;

    /**
     * @var string $LocationName
     */
    protected $LocationName = null;

    /**
     * @var \DateTime $TransactionDate
     */
    protected $TransactionDate = null;

    /**
     * @var TransactionTypeCode $TransactionType
     */
    protected $TransactionType = null;

    /**
     * @var int $VoucherEntryId
     */
    protected $VoucherEntryId = null;

    /**
     * @var int $VoucherId
     */
    protected $VoucherId = null;

    /**
     * @var string $VoucherNumber
     */
    protected $VoucherNumber = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return float
     */
    public function getAmount()
    {
      return $this->Amount;
    }

    /**
     * @param float $Amount
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setAmount($Amount)
    {
      $this->Amount = $Amount;
      return $this;
    }

    /**
     * @return GiftCardEntryType
     */
    public function getEntryType()
    {
      return $this->EntryType;
    }

    /**
     * @param GiftCardEntryType $EntryType
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setEntryType($EntryType)
    {
      $this->EntryType = $EntryType;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalTransactionNumber()
    {
      return $this->ExternalTransactionNumber;
    }

    /**
     * @param int $ExternalTransactionNumber
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setExternalTransactionNumber($ExternalTransactionNumber)
    {
      $this->ExternalTransactionNumber = $ExternalTransactionNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getExternalVoucherEntryId()
    {
      return $this->ExternalVoucherEntryId;
    }

    /**
     * @param int $ExternalVoucherEntryId
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setExternalVoucherEntryId($ExternalVoucherEntryId)
    {
      $this->ExternalVoucherEntryId = $ExternalVoucherEntryId;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationCode()
    {
      return $this->LocationCode;
    }

    /**
     * @param string $LocationCode
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setLocationCode($LocationCode)
    {
      $this->LocationCode = $LocationCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationName()
    {
      return $this->LocationName;
    }

    /**
     * @param string $LocationName
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setLocationName($LocationName)
    {
      $this->LocationName = $LocationName;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTransactionDate()
    {
      if ($this->TransactionDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->TransactionDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $TransactionDate
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setTransactionDate(\DateTime $TransactionDate = null)
    {
      if ($TransactionDate == null) {
       $this->TransactionDate = null;
      } else {
        $this->TransactionDate = $TransactionDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return TransactionTypeCode
     */
    public function getTransactionType()
    {
      return $this->TransactionType;
    }

    /**
     * @param TransactionTypeCode $TransactionType
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setTransactionType($TransactionType)
    {
      $this->TransactionType = $TransactionType;
      return $this;
    }

    /**
     * @return int
     */
    public function getVoucherEntryId()
    {
      return $this->VoucherEntryId;
    }

    /**
     * @param int $VoucherEntryId
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setVoucherEntryId($VoucherEntryId)
    {
      $this->VoucherEntryId = $VoucherEntryId;
      return $this;
    }

    /**
     * @return int
     */
    public function getVoucherId()
    {
      return $this->VoucherId;
    }

    /**
     * @param int $VoucherId
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setVoucherId($VoucherId)
    {
      $this->VoucherId = $VoucherId;
      return $this;
    }

    /**
     * @return string
     */
    public function getVoucherNumber()
    {
      return $this->VoucherNumber;
    }

    /**
     * @param string $VoucherNumber
     * @return \Opsuite\Voucher\GiftCardEntry
     */
    public function setVoucherNumber($VoucherNumber)
    {
      $this->VoucherNumber = $VoucherNumber;
      return $this;
    }

}
