<?php

namespace Opsuite\Voucher;

class GiftCard
{

    /**
     * @var boolean $AllowTopup
     */
    protected $AllowTopup = null;

    /**
     * @var float $Balance
     */
    protected $Balance = null;

    /**
     * @var int $ExpiryBasis
     */
    protected $ExpiryBasis = null;

    /**
     * @var \DateTime $ExpiryDate
     */
    protected $ExpiryDate = null;

    /**
     * @var int $ExpiryDays
     */
    protected $ExpiryDays = null;

    /**
     * @var boolean $HasExpired
     */
    protected $HasExpired = null;

    /**
     * @var boolean $HasTenders
     */
    protected $HasTenders = null;

    /**
     * @var \DateTime $IssueDate
     */
    protected $IssueDate = null;

    /**
     * @var string $IssuingLocationCode
     */
    protected $IssuingLocationCode = null;

    /**
     * @var string $IssuingLocationName
     */
    protected $IssuingLocationName = null;

    /**
     * @var int $ItemMasterId
     */
    protected $ItemMasterId = null;

    /**
     * @var boolean $PrintVoucherAfterSale
     */
    protected $PrintVoucherAfterSale = null;

    /**
     * @var boolean $PrintVoucherAfterTender
     */
    protected $PrintVoucherAfterTender = null;

    /**
     * @var string $VoucherDescription
     */
    protected $VoucherDescription = null;

    /**
     * @var int $VoucherId
     */
    protected $VoucherId = null;

    /**
     * @var string $VoucherNumber
     */
    protected $VoucherNumber = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return boolean
     */
    public function getAllowTopup()
    {
      return $this->AllowTopup;
    }

    /**
     * @param boolean $AllowTopup
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setAllowTopup($AllowTopup)
    {
      $this->AllowTopup = $AllowTopup;
      return $this;
    }

    /**
     * @return float
     */
    public function getBalance()
    {
      return $this->Balance;
    }

    /**
     * @param float $Balance
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setBalance($Balance)
    {
      $this->Balance = $Balance;
      return $this;
    }

    /**
     * @return int
     */
    public function getExpiryBasis()
    {
      return $this->ExpiryBasis;
    }

    /**
     * @param int $ExpiryBasis
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setExpiryBasis($ExpiryBasis)
    {
      $this->ExpiryBasis = $ExpiryBasis;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getExpiryDate()
    {
      if ($this->ExpiryDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ExpiryDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ExpiryDate
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setExpiryDate(\DateTime $ExpiryDate = null)
    {
      if ($ExpiryDate == null) {
       $this->ExpiryDate = null;
      } else {
        $this->ExpiryDate = $ExpiryDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getExpiryDays()
    {
      return $this->ExpiryDays;
    }

    /**
     * @param int $ExpiryDays
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setExpiryDays($ExpiryDays)
    {
      $this->ExpiryDays = $ExpiryDays;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getHasExpired()
    {
      return $this->HasExpired;
    }

    /**
     * @param boolean $HasExpired
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setHasExpired($HasExpired)
    {
      $this->HasExpired = $HasExpired;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getHasTenders()
    {
      return $this->HasTenders;
    }

    /**
     * @param boolean $HasTenders
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setHasTenders($HasTenders)
    {
      $this->HasTenders = $HasTenders;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getIssueDate()
    {
      if ($this->IssueDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->IssueDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $IssueDate
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setIssueDate(\DateTime $IssueDate = null)
    {
      if ($IssueDate == null) {
       $this->IssueDate = null;
      } else {
        $this->IssueDate = $IssueDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getIssuingLocationCode()
    {
      return $this->IssuingLocationCode;
    }

    /**
     * @param string $IssuingLocationCode
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setIssuingLocationCode($IssuingLocationCode)
    {
      $this->IssuingLocationCode = $IssuingLocationCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getIssuingLocationName()
    {
      return $this->IssuingLocationName;
    }

    /**
     * @param string $IssuingLocationName
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setIssuingLocationName($IssuingLocationName)
    {
      $this->IssuingLocationName = $IssuingLocationName;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemMasterId()
    {
      return $this->ItemMasterId;
    }

    /**
     * @param int $ItemMasterId
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setItemMasterId($ItemMasterId)
    {
      $this->ItemMasterId = $ItemMasterId;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getPrintVoucherAfterSale()
    {
      return $this->PrintVoucherAfterSale;
    }

    /**
     * @param boolean $PrintVoucherAfterSale
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setPrintVoucherAfterSale($PrintVoucherAfterSale)
    {
      $this->PrintVoucherAfterSale = $PrintVoucherAfterSale;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getPrintVoucherAfterTender()
    {
      return $this->PrintVoucherAfterTender;
    }

    /**
     * @param boolean $PrintVoucherAfterTender
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setPrintVoucherAfterTender($PrintVoucherAfterTender)
    {
      $this->PrintVoucherAfterTender = $PrintVoucherAfterTender;
      return $this;
    }

    /**
     * @return string
     */
    public function getVoucherDescription()
    {
      return $this->VoucherDescription;
    }

    /**
     * @param string $VoucherDescription
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setVoucherDescription($VoucherDescription)
    {
      $this->VoucherDescription = $VoucherDescription;
      return $this;
    }

    /**
     * @return int
     */
    public function getVoucherId()
    {
      return $this->VoucherId;
    }

    /**
     * @param int $VoucherId
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setVoucherId($VoucherId)
    {
      $this->VoucherId = $VoucherId;
      return $this;
    }

    /**
     * @return string
     */
    public function getVoucherNumber()
    {
      return $this->VoucherNumber;
    }

    /**
     * @param string $VoucherNumber
     * @return \Opsuite\Voucher\GiftCard
     */
    public function setVoucherNumber($VoucherNumber)
    {
      $this->VoucherNumber = $VoucherNumber;
      return $this;
    }

}
