<?php

namespace Opsuite\Voucher;

class ArrayOfGiftCardEntry implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var GiftCardEntry[] $GiftCardEntry
     */
    protected $GiftCardEntry = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return GiftCardEntry[]
     */
    public function getGiftCardEntry()
    {
      return $this->GiftCardEntry;
    }

    /**
     * @param GiftCardEntry[] $GiftCardEntry
     * @return \Opsuite\Voucher\ArrayOfGiftCardEntry
     */
    public function setGiftCardEntry(array $GiftCardEntry = null)
    {
      $this->GiftCardEntry = $GiftCardEntry;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->GiftCardEntry[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return GiftCardEntry
     */
    public function offsetGet($offset)
    {
      return $this->GiftCardEntry[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param GiftCardEntry $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->GiftCardEntry[] = $value;
      } else {
        $this->GiftCardEntry[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->GiftCardEntry[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return GiftCardEntry Return the current element
     */
    public function current()
    {
      return current($this->GiftCardEntry);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->GiftCardEntry);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->GiftCardEntry);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->GiftCardEntry);
    }

    /**
     * Countable implementation
     *
     * @return GiftCardEntry Return count of elements
     */
    public function count()
    {
      return count($this->GiftCardEntry);
    }

}
