<?php

namespace Opsuite\TransferOrder;

use Opsuite\WSSSoapClient;

class TransferOrderService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfTransferOrder' => 'Opsuite\\TransferOrder\\ArrayOfTransferOrder',
      'TransferOrder' => 'Opsuite\\TransferOrder\\TransferOrder',
      'ArrayOfTransferOrderItem' => 'Opsuite\\TransferOrder\\ArrayOfTransferOrderItem',
      'TransferOrderItem' => 'Opsuite\\TransferOrder\\TransferOrderItem',
      'ArrayOfstring' => 'Opsuite\\TransferOrder\\ArrayOfstring',
      'GetTransferOrders' => 'Opsuite\\TransferOrder\\GetTransferOrders',
      'GetTransferOrdersResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersResponse',
      'GetTransferOrdersByLocationCode' => 'Opsuite\\TransferOrder\\GetTransferOrdersByLocationCode',
      'GetTransferOrdersByLocationCodeResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersByLocationCodeResponse',
      'GetTransferOrdersByDate' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDate',
      'GetTransferOrdersByDateResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateResponse',
      'GetTransferOrdersByDateAndLocationCode' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateAndLocationCode',
      'GetTransferOrdersByDateAndLocationCodeResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateAndLocationCodeResponse',
      'GetTransferOrdersBySupplierCode' => 'Opsuite\\TransferOrder\\GetTransferOrdersBySupplierCode',
      'GetTransferOrdersBySupplierCodeResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersBySupplierCodeResponse',
      'GetTransferOrdersByDateAndSupplierCode' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateAndSupplierCode',
      'GetTransferOrdersByDateAndSupplierCodeResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateAndSupplierCodeResponse',
      'GetTransferOrdersByDateAndLocationAndSupplier' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateAndLocationAndSupplier',
      'GetTransferOrdersByDateAndLocationAndSupplierResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersByDateAndLocationAndSupplierResponse',
      'GetTransferOrdersByOrderNumber' => 'Opsuite\\TransferOrder\\GetTransferOrdersByOrderNumber',
      'GetTransferOrdersByOrderNumberResponse' => 'Opsuite\\TransferOrder\\GetTransferOrdersByOrderNumberResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/TransferOrderService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetTransferOrders $parameters
     * @return GetTransferOrdersResponse
     */
    public function GetTransferOrders(GetTransferOrders $parameters)
    {
      return $this->__soapCall('GetTransferOrders', array($parameters));
    }

    /**
     * @param GetTransferOrdersByLocationCode $parameters
     * @return GetTransferOrdersByLocationCodeResponse
     */
    public function GetTransferOrdersByLocationCode(GetTransferOrdersByLocationCode $parameters)
    {
      return $this->__soapCall('GetTransferOrdersByLocationCode', array($parameters));
    }

    /**
     * @param GetTransferOrdersByDate $parameters
     * @return GetTransferOrdersByDateResponse
     */
    public function GetTransferOrdersByDate(GetTransferOrdersByDate $parameters)
    {
      return $this->__soapCall('GetTransferOrdersByDate', array($parameters));
    }

    /**
     * @param GetTransferOrdersByDateAndLocationCode $parameters
     * @return GetTransferOrdersByDateAndLocationCodeResponse
     */
    public function GetTransferOrdersByDateAndLocationCode(GetTransferOrdersByDateAndLocationCode $parameters)
    {
      return $this->__soapCall('GetTransferOrdersByDateAndLocationCode', array($parameters));
    }

    /**
     * @param GetTransferOrdersBySupplierCode $parameters
     * @return GetTransferOrdersBySupplierCodeResponse
     */
    public function GetTransferOrdersBySupplierCode(GetTransferOrdersBySupplierCode $parameters)
    {
      return $this->__soapCall('GetTransferOrdersBySupplierCode', array($parameters));
    }

    /**
     * @param GetTransferOrdersByDateAndSupplierCode $parameters
     * @return GetTransferOrdersByDateAndSupplierCodeResponse
     */
    public function GetTransferOrdersByDateAndSupplierCode(GetTransferOrdersByDateAndSupplierCode $parameters)
    {
      return $this->__soapCall('GetTransferOrdersByDateAndSupplierCode', array($parameters));
    }

    /**
     * @param GetTransferOrdersByDateAndLocationAndSupplier $parameters
     * @return GetTransferOrdersByDateAndLocationAndSupplierResponse
     */
    public function GetTransferOrdersByDateAndLocationAndSupplier(GetTransferOrdersByDateAndLocationAndSupplier $parameters)
    {
      return $this->__soapCall('GetTransferOrdersByDateAndLocationAndSupplier', array($parameters));
    }

    /**
     * @param GetTransferOrdersByOrderNumber $parameters
     * @return GetTransferOrdersByOrderNumberResponse
     */
    public function GetTransferOrdersByOrderNumber(GetTransferOrdersByOrderNumber $parameters)
    {
      return $this->__soapCall('GetTransferOrdersByOrderNumber', array($parameters));
    }

}
