<?php

namespace Opsuite\TransferOrder;

class TransferOrderItem
{

    /**
     * @var float $Cost
     */
    protected $Cost = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var float $ExtendedCost
     */
    protected $ExtendedCost = null;

    /**
     * @var int $Id
     */
    protected $Id = null;

    /**
     * @var int $ItemId
     */
    protected $ItemId = null;

    /**
     * @var int $LocationId
     */
    protected $LocationId = null;

    /**
     * @var string $LocationName
     */
    protected $LocationName = null;

    /**
     * @var string $OrderNumber
     */
    protected $OrderNumber = null;

    /**
     * @var float $QuantityOrdered
     */
    protected $QuantityOrdered = null;

    /**
     * @var string $ReorderNumber
     */
    protected $ReorderNumber = null;

    /**
     * @var string $StoreSku
     */
    protected $StoreSku = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return float
     */
    public function getCost()
    {
      return $this->Cost;
    }

    /**
     * @param float $Cost
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setCost($Cost)
    {
      $this->Cost = $Cost;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return float
     */
    public function getExtendedCost()
    {
      return $this->ExtendedCost;
    }

    /**
     * @param float $ExtendedCost
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setExtendedCost($ExtendedCost)
    {
      $this->ExtendedCost = $ExtendedCost;
      return $this;
    }

    /**
     * @return int
     */
    public function getId()
    {
      return $this->Id;
    }

    /**
     * @param int $Id
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setId($Id)
    {
      $this->Id = $Id;
      return $this;
    }

    /**
     * @return int
     */
    public function getItemId()
    {
      return $this->ItemId;
    }

    /**
     * @param int $ItemId
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setItemId($ItemId)
    {
      $this->ItemId = $ItemId;
      return $this;
    }

    /**
     * @return int
     */
    public function getLocationId()
    {
      return $this->LocationId;
    }

    /**
     * @param int $LocationId
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setLocationId($LocationId)
    {
      $this->LocationId = $LocationId;
      return $this;
    }

    /**
     * @return string
     */
    public function getLocationName()
    {
      return $this->LocationName;
    }

    /**
     * @param string $LocationName
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setLocationName($LocationName)
    {
      $this->LocationName = $LocationName;
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderNumber()
    {
      return $this->OrderNumber;
    }

    /**
     * @param string $OrderNumber
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setOrderNumber($OrderNumber)
    {
      $this->OrderNumber = $OrderNumber;
      return $this;
    }

    /**
     * @return float
     */
    public function getQuantityOrdered()
    {
      return $this->QuantityOrdered;
    }

    /**
     * @param float $QuantityOrdered
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setQuantityOrdered($QuantityOrdered)
    {
      $this->QuantityOrdered = $QuantityOrdered;
      return $this;
    }

    /**
     * @return string
     */
    public function getReorderNumber()
    {
      return $this->ReorderNumber;
    }

    /**
     * @param string $ReorderNumber
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setReorderNumber($ReorderNumber)
    {
      $this->ReorderNumber = $ReorderNumber;
      return $this;
    }

    /**
     * @return string
     */
    public function getStoreSku()
    {
      return $this->StoreSku;
    }

    /**
     * @param string $StoreSku
     * @return \Opsuite\TransferOrder\TransferOrderItem
     */
    public function setStoreSku($StoreSku)
    {
      $this->StoreSku = $StoreSku;
      return $this;
    }

}
