<?php

namespace Opsuite\TransferOrder;

class GetTransferOrdersByDateAndSupplierCode
{

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var DateFilterType $dateType
     */
    protected $dateType = null;

    /**
     * @var ArrayOfstring $supplierCodes
     */
    protected $supplierCodes = null;

    /**
     * @var POStatus $status
     */
    protected $status = null;

    /**
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param DateFilterType $dateType
     * @param ArrayOfstring $supplierCodes
     * @param POStatus $status
     */
    public function __construct(\DateTime $startDate, \DateTime $endDate, $dateType, $supplierCodes, $status)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->dateType = $dateType;
      $this->supplierCodes = $supplierCodes;
      $this->status = $status;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndSupplierCode
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndSupplierCode
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return DateFilterType
     */
    public function getDateType()
    {
      return $this->dateType;
    }

    /**
     * @param DateFilterType $dateType
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndSupplierCode
     */
    public function setDateType($dateType)
    {
      $this->dateType = $dateType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getSupplierCodes()
    {
      return $this->supplierCodes;
    }

    /**
     * @param ArrayOfstring $supplierCodes
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndSupplierCode
     */
    public function setSupplierCodes($supplierCodes)
    {
      $this->supplierCodes = $supplierCodes;
      return $this;
    }

    /**
     * @return POStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param POStatus $status
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndSupplierCode
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
