<?php

namespace Opsuite\TransferOrder;

class GetTransferOrdersByDateAndLocationCode
{

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var DateFilterType $dateType
     */
    protected $dateType = null;

    /**
     * @var ArrayOfstring $locationCodes
     */
    protected $locationCodes = null;

    /**
     * @var POStatus $status
     */
    protected $status = null;

    /**
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param DateFilterType $dateType
     * @param ArrayOfstring $locationCodes
     * @param POStatus $status
     */
    public function __construct(\DateTime $startDate, \DateTime $endDate, $dateType, $locationCodes, $status)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->dateType = $dateType;
      $this->locationCodes = $locationCodes;
      $this->status = $status;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndLocationCode
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndLocationCode
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return DateFilterType
     */
    public function getDateType()
    {
      return $this->dateType;
    }

    /**
     * @param DateFilterType $dateType
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndLocationCode
     */
    public function setDateType($dateType)
    {
      $this->dateType = $dateType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getLocationCodes()
    {
      return $this->locationCodes;
    }

    /**
     * @param ArrayOfstring $locationCodes
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndLocationCode
     */
    public function setLocationCodes($locationCodes)
    {
      $this->locationCodes = $locationCodes;
      return $this;
    }

    /**
     * @return POStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param POStatus $status
     * @return \Opsuite\TransferOrder\GetTransferOrdersByDateAndLocationCode
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

}
