<?php

namespace Opsuite\TransferOrder;

class ArrayOfTransferOrderItem implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TransferOrderItem[] $TransferOrderItem
     */
    protected $TransferOrderItem = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TransferOrderItem[]
     */
    public function getTransferOrderItem()
    {
      return $this->TransferOrderItem;
    }

    /**
     * @param TransferOrderItem[] $TransferOrderItem
     * @return \Opsuite\TransferOrder\ArrayOfTransferOrderItem
     */
    public function setTransferOrderItem(array $TransferOrderItem = null)
    {
      $this->TransferOrderItem = $TransferOrderItem;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TransferOrderItem[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TransferOrderItem
     */
    public function offsetGet($offset)
    {
      return $this->TransferOrderItem[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TransferOrderItem $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TransferOrderItem[] = $value;
      } else {
        $this->TransferOrderItem[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TransferOrderItem[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TransferOrderItem Return the current element
     */
    public function current()
    {
      return current($this->TransferOrderItem);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TransferOrderItem);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TransferOrderItem);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TransferOrderItem);
    }

    /**
     * Countable implementation
     *
     * @return TransferOrderItem Return count of elements
     */
    public function count()
    {
      return count($this->TransferOrderItem);
    }

}
