<?php

namespace Opsuite\TransferOrder;

class ArrayOfTransferOrder implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var TransferOrder[] $TransferOrder
     */
    protected $TransferOrder = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return TransferOrder[]
     */
    public function getTransferOrder()
    {
      return $this->TransferOrder;
    }

    /**
     * @param TransferOrder[] $TransferOrder
     * @return \Opsuite\TransferOrder\ArrayOfTransferOrder
     */
    public function setTransferOrder(array $TransferOrder = null)
    {
      $this->TransferOrder = $TransferOrder;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->TransferOrder[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return TransferOrder
     */
    public function offsetGet($offset)
    {
      return $this->TransferOrder[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param TransferOrder $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->TransferOrder[] = $value;
      } else {
        $this->TransferOrder[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->TransferOrder[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return TransferOrder Return the current element
     */
    public function current()
    {
      return current($this->TransferOrder);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->TransferOrder);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->TransferOrder);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->TransferOrder);
    }

    /**
     * Countable implementation
     *
     * @return TransferOrder Return count of elements
     */
    public function count()
    {
      return count($this->TransferOrder);
    }

}
