<?php

namespace Opsuite\Transaction;

use Opsuite\WSSSoapClient;

class TransactionService extends WSSSoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'ArrayOfErrorInfo' => 'Opsuite\\Transaction\\ArrayOfErrorInfo',
      'ErrorInfo' => 'Opsuite\\Transaction\\ErrorInfo',
      'SubmitResultOfBatchv2D6QioO' => 'Opsuite\\Transaction\\SubmitResultOfBatchv2D6QioO',
      'ArrayOfErrorInfoOfBatchv2D6QioO' => 'Opsuite\\Transaction\\ArrayOfErrorInfoOfBatchv2D6QioO',
      'ErrorInfoOfBatchv2D6QioO' => 'Opsuite\\Transaction\\ErrorInfoOfBatchv2D6QioO',
      'ArrayOfAccountType' => 'Opsuite\\Transaction\\ArrayOfAccountType',
      'AccountType' => 'Opsuite\\Transaction\\AccountType',
      'ArrayOfCommunity' => 'Opsuite\\Transaction\\ArrayOfCommunity',
      'Community' => 'Opsuite\\Transaction\\Community',
      'RetailTransaction' => 'Opsuite\\Transaction\\RetailTransaction',
      'ArrayOfRetailTransactionLineItem' => 'Opsuite\\Transaction\\ArrayOfRetailTransactionLineItem',
      'RetailTransactionLineItem' => 'Opsuite\\Transaction\\RetailTransactionLineItem',
      'ArrayOfTransactionLineBenefit' => 'Opsuite\\Transaction\\ArrayOfTransactionLineBenefit',
      'TransactionLineBenefit' => 'Opsuite\\Transaction\\TransactionLineBenefit',
      'ArrayOfRetailTransactionTenderLineItem' => 'Opsuite\\Transaction\\ArrayOfRetailTransactionTenderLineItem',
      'RetailTransactionTenderLineItem' => 'Opsuite\\Transaction\\RetailTransactionTenderLineItem',
      'ArrayOfTransactionBenefit' => 'Opsuite\\Transaction\\ArrayOfTransactionBenefit',
      'TransactionBenefit' => 'Opsuite\\Transaction\\TransactionBenefit',
      'SubmitTransactionResult' => 'Opsuite\\Transaction\\SubmitTransactionResult',
      'Batch' => 'Opsuite\\Transaction\\Batch',
      'ArrayOfBatchTenderAmount' => 'Opsuite\\Transaction\\ArrayOfBatchTenderAmount',
      'BatchTenderAmount' => 'Opsuite\\Transaction\\BatchTenderAmount',
      'ArrayOfSpecialOffer' => 'Opsuite\\Transaction\\ArrayOfSpecialOffer',
      'SpecialOffer' => 'Opsuite\\Transaction\\SpecialOffer',
      'SubmitTransaction' => 'Opsuite\\Transaction\\SubmitTransaction',
      'SubmitTransactionResponse' => 'Opsuite\\Transaction\\SubmitTransactionResponse',
      'SubmitClosedBatch' => 'Opsuite\\Transaction\\SubmitClosedBatch',
      'SubmitClosedBatchResponse' => 'Opsuite\\Transaction\\SubmitClosedBatchResponse',
      'GetSpecialOffers' => 'Opsuite\\Transaction\\GetSpecialOffers',
      'GetSpecialOffersResponse' => 'Opsuite\\Transaction\\GetSpecialOffersResponse',
      'RefundTransactionByTransactionId' => 'Opsuite\\Transaction\\RefundTransactionByTransactionId',
      'RefundTransactionByTransactionIdResponse' => 'Opsuite\\Transaction\\RefundTransactionByTransactionIdResponse',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://services.goopsuite.co.uk/2013/08/TransactionService.svc?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param SubmitTransaction $parameters
     * @return SubmitTransactionResponse
     */
    public function SubmitTransaction(SubmitTransaction $parameters)
    {
      return $this->__soapCall('SubmitTransaction', array($parameters));
    }

    /**
     * @param SubmitClosedBatch $parameters
     * @return SubmitClosedBatchResponse
     */
    public function SubmitClosedBatch(SubmitClosedBatch $parameters)
    {
      return $this->__soapCall('SubmitClosedBatch', array($parameters));
    }

    /**
     * @param GetSpecialOffers $parameters
     * @return GetSpecialOffersResponse
     */
    public function GetSpecialOffers(GetSpecialOffers $parameters)
    {
      return $this->__soapCall('GetSpecialOffers', array($parameters));
    }

    /**
     * @param RefundTransactionByTransactionId $parameters
     * @return RefundTransactionByTransactionIdResponse
     */
    public function RefundTransactionByTransactionId(RefundTransactionByTransactionId $parameters)
    {
      return $this->__soapCall('RefundTransactionByTransactionId', array($parameters));
    }

}
